/*
 * Decompiled with CFR 0.152.
 */
package me.Vextricity.sek.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.Vextricity.sek.Main;
import me.Vextricity.sek.utils.FileUtils;
import net.ess3.api.IEssentials;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class KitUtils {
    Main plugin;
    IEssentials ess;

    public KitUtils(Main pl) {
        this.plugin = pl;
    }

    public static Plugin getEssPlugin() {
        return Bukkit.getServer().getPluginManager().getPlugin("Essentials");
    }

    public void addKit(String name, Inventory inv, int cooldown, int money, int cost) throws IOException {
        ArrayList<String> items = new ArrayList<String>();
        ItemStack[] itemStackArray = inv.getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack i = itemStackArray[n2];
            if (i != null) {
                String itemlist = String.valueOf(i.getTypeId()) + ":" + i.getDurability() + " " + i.getAmount();
                if (i.hasItemMeta()) {
                    if (i.getItemMeta() instanceof BookMeta) {
                        BookMeta bm = (BookMeta)i.getItemMeta();
                        File file = new File(KitUtils.getEssPlugin().getDataFolder(), "book.txt");
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        FileUtils fw = new FileUtils(this.plugin);
                        String title = bm.getTitle().replace(" ", "_");
                        if (fw.readFile(KitUtils.getEssPlugin().getDataFolder(), "book.txt").contains("#" + title)) {
                            fw.removeLineFromFile(file.getName(), "#" + title);
                        }
                        fw.logToFile(file, "");
                        fw.logToFile(file, "");
                        fw.logToFile(file, "#" + title);
                        for (String s : bm.getPages()) {
                            fw.logToFile(file, s.trim());
                        }
                        if (bm.getTitle() == null) {
                            bm.setTitle(bm.getDisplayName());
                        }
                        itemlist = !bm.hasDisplayName() ? String.valueOf(itemlist) + " book:" + bm.getTitle().replace(" ", "_") + " author:" + bm.getAuthor() + " title:&r" + title : String.valueOf(itemlist) + " book:" + bm.getTitle().replace(" ", "_") + " author:" + bm.getAuthor() + " title:&r" + bm.getDisplayName().replace(" ", "_");
                    }
                    if (i.getItemMeta().hasDisplayName() && !(i.getItemMeta() instanceof BookMeta)) {
                        itemlist = String.valueOf(itemlist) + " name:" + i.getItemMeta().getDisplayName().replace(" ", "_");
                    }
                    if (i.getItemMeta().hasLore()) {
                        List lore = i.getItemMeta().getLore();
                        StringBuilder str = new StringBuilder();
                        int in = 0;
                        while (in < lore.size()) {
                            str.append(String.valueOf((String)lore.get(in)) + "|");
                            ++in;
                        }
                        String finallore = StringUtils.removeEnd((String)str.toString().trim(), (String)"|").replace(" ", "_");
                        itemlist = String.valueOf(itemlist) + " lore:" + finallore;
                    }
                    for (Enchantment e : i.getEnchantments().keySet()) {
                        itemlist = String.valueOf(itemlist) + " " + e.getName().toLowerCase() + ":" + i.getEnchantmentLevel(e);
                    }
                }
                items.add(itemlist);
            }
            ++n2;
        }
        YamlConfiguration c = YamlConfiguration.loadConfiguration((File)new File(KitUtils.getEssPlugin().getDataFolder(), "config.yml"));
        if (money != 0) {
            items.add("$" + money);
        }
        if (cost != 0) {
            c.set("command-costs.kit-" + name, (Object)cost);
        }
        c.set("kits." + name + ".delay", (Object)cooldown);
        c.set("kits." + name + ".items", items);
        c.save(new File(KitUtils.getEssPlugin().getDataFolder(), "config.yml"));
    }

    public void removeKit(String name) throws IOException {
        YamlConfiguration c = YamlConfiguration.loadConfiguration((File)new File(KitUtils.getEssPlugin().getDataFolder(), "config.yml"));
        c.set("kits." + name, null);
        c.save(new File(KitUtils.getEssPlugin().getDataFolder(), "config.yml"));
    }

    public void setDelay(String name, int delay) throws IOException {
        YamlConfiguration c = YamlConfiguration.loadConfiguration((File)new File(KitUtils.getEssPlugin().getDataFolder(), "config.yml"));
        c.set("kits." + name + ".delay", (Object)delay);
        c.save(new File(KitUtils.getEssPlugin().getDataFolder(), "config.yml"));
    }

    public void setMoney(String name, int money) throws IOException {
        YamlConfiguration c = YamlConfiguration.loadConfiguration((File)new File(KitUtils.getEssPlugin().getDataFolder(), "config.yml"));
        List kit = c.getStringList("kits." + name + ".items");
        String moneys = "";
        for (String items : kit) {
            if (!items.startsWith("$")) continue;
            moneys = items;
        }
        kit.remove(moneys);
        if (money != 0) {
            kit.add("$" + money);
        }
        c.set("kits." + name + ".items", (Object)kit);
        c.save(new File(KitUtils.getEssPlugin().getDataFolder(), "config.yml"));
    }

    public void setCost(String name, int cost) throws IOException {
        YamlConfiguration c = YamlConfiguration.loadConfiguration((File)new File(KitUtils.getEssPlugin().getDataFolder(), "config.yml"));
        if (cost != 0) {
            c.set("command-costs.kit-" + name, (Object)cost);
        } else {
            c.set("command-costs.kit-" + name, null);
        }
        c.save(new File(KitUtils.getEssPlugin().getDataFolder(), "config.yml"));
    }

    public int getDelay(String name) {
        YamlConfiguration c = YamlConfiguration.loadConfiguration((File)new File(KitUtils.getEssPlugin().getDataFolder(), "config.yml"));
        int delay = c.getInt("kits." + name + ".delay");
        return delay;
    }

    public int getMoney(String name) {
        YamlConfiguration c = YamlConfiguration.loadConfiguration((File)new File(KitUtils.getEssPlugin().getDataFolder(), "config.yml"));
        int money = 0;
        List kit = c.getStringList("kits." + name + ".items");
        for (String items : kit) {
            if (!items.startsWith("$")) continue;
            try {
                money = Integer.parseInt(items.replace("$", ""));
            }
            catch (NumberFormatException e) {
                money = 0;
            }
        }
        return money;
    }

    public int getCost(String name) {
        YamlConfiguration c = YamlConfiguration.loadConfiguration((File)new File(KitUtils.getEssPlugin().getDataFolder(), "config.yml"));
        int cost = c.getInt("command-costs.kit-" + name);
        return cost;
    }

    public boolean kitExist(String kitName) {
        YamlConfiguration c = YamlConfiguration.loadConfiguration((File)new File(KitUtils.getEssPlugin().getDataFolder(), "config.yml"));
        if (c.getString("kits." + kitName.toLowerCase()) != null) {
            return true;
        }
        return c.getString("kits." + kitName) != null;
    }

    public void editKit(Player p, String name) throws IOException, ArrayIndexOutOfBoundsException {
        YamlConfiguration c = YamlConfiguration.loadConfiguration((File)new File(KitUtils.getEssPlugin().getDataFolder(), "config.yml"));
        List items = c.getStringList("kits." + name + ".items");
        Inventory inv = Bukkit.createInventory((InventoryHolder)p, (int)36, (String)("Editing kit - " + name));
        for (String s : items) {
            int data;
            if (s.contains("$")) continue;
            String[] args = s.split(" ");
            String[] ints = args[0].split(":");
            int id = Integer.parseInt(ints[0]);
            try {
                data = Integer.parseInt(ints[1]);
            }
            catch (IndexOutOfBoundsException e) {
                data = 0;
            }
            ItemStack item = new ItemStack(Material.getMaterial((int)id), Integer.parseInt(args[1]), (short)data);
            ItemMeta im = item.getItemMeta();
            if (im instanceof BookMeta) {
                p.sendMessage(String.valueOf(this.plugin.prefix) + "You cannot edit kits that contain books. Please use /sek additem instead.");
            }
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String loop = stringArray[n2];
                if (loop.startsWith("name:") && !(im instanceof BookMeta)) {
                    String[] names = loop.split(":");
                    String itemname = names[1];
                    im.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)itemname.replace("_", " ")));
                }
                if (loop.startsWith("lore:")) {
                    String[] slores = loop.split(":");
                    String[] lores = slores[1].split("\\|");
                    ArrayList<String> lore = new ArrayList<String>();
                    String[] stringArray2 = lores;
                    int n3 = lores.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String line = stringArray2[n4];
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                        ++n4;
                    }
                    im.setLore(lore);
                }
                for (Enchantment e : this.getAllEnchantments()) {
                    if (!loop.startsWith(String.valueOf(e.getName().toLowerCase()) + ":")) continue;
                    String[] info = loop.split(":");
                    String level = info[1];
                    im.addEnchant(e, Integer.parseInt(level), true);
                }
                ++n2;
            }
            item.setItemMeta(im);
            inv.addItem(new ItemStack[]{item});
        }
        p.openInventory(inv);
        c.save(new File(KitUtils.getEssPlugin().getDataFolder(), "config.yml"));
    }

    public void addItem(String name, ItemStack i) throws IOException {
        YamlConfiguration c = YamlConfiguration.loadConfiguration((File)new File(KitUtils.getEssPlugin().getDataFolder(), "config.yml"));
        List items = c.getStringList("kits." + name + ".items");
        if (i != null) {
            String itemlist = String.valueOf(i.getTypeId()) + ":" + i.getDurability() + " " + i.getAmount();
            if (i.hasItemMeta()) {
                if (i.getItemMeta() instanceof BookMeta) {
                    BookMeta bm = (BookMeta)i.getItemMeta();
                    File file = new File(KitUtils.getEssPlugin().getDataFolder(), "book.txt");
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileUtils fw = new FileUtils(this.plugin);
                    String title = bm.getTitle().replace(" ", "_");
                    if (fw.readFile(KitUtils.getEssPlugin().getDataFolder(), "book.txt").contains("#" + title)) {
                        fw.removeLineFromFile(file.getName(), "#" + title);
                    }
                    fw.logToFile(file, "");
                    fw.logToFile(file, "");
                    fw.logToFile(file, "#" + title);
                    for (String s : bm.getPages()) {
                        fw.logToFile(file, s.trim());
                    }
                    if (bm.getTitle() == null) {
                        bm.setTitle(bm.getDisplayName());
                    }
                    itemlist = !bm.hasDisplayName() ? String.valueOf(itemlist) + " book:" + bm.getTitle().replace(" ", "_") + " author:" + bm.getAuthor() + " title:&r" + title : String.valueOf(itemlist) + " book:" + bm.getTitle().replace(" ", "_") + " author:" + bm.getAuthor() + " title:&r" + bm.getDisplayName().replace(" ", "_");
                }
                if (i.getItemMeta().hasDisplayName() && !(i.getItemMeta() instanceof BookMeta)) {
                    itemlist = String.valueOf(itemlist) + " name:" + i.getItemMeta().getDisplayName().replace(" ", "_");
                }
                if (i.getItemMeta().hasLore()) {
                    List lore = i.getItemMeta().getLore();
                    StringBuilder str = new StringBuilder();
                    int in = 0;
                    while (in < lore.size()) {
                        str.append(String.valueOf((String)lore.get(in)) + "|");
                        ++in;
                    }
                    String finallore = StringUtils.removeEnd((String)str.toString().trim(), (String)"|").replace(" ", "_");
                    itemlist = String.valueOf(itemlist) + " lore:" + finallore;
                }
                for (Enchantment e : i.getEnchantments().keySet()) {
                    itemlist = String.valueOf(itemlist) + " " + e.getName().toLowerCase() + ":" + i.getEnchantmentLevel(e);
                }
            }
            items.add(itemlist);
            c.set("kits." + name + ".items", (Object)items);
            c.save(new File(KitUtils.getEssPlugin().getDataFolder(), "config.yml"));
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"ess rl");
        }
    }

    public List<Enchantment> getAllEnchantments() {
        ArrayList<Enchantment> e = new ArrayList<Enchantment>();
        e.add(Enchantment.ARROW_DAMAGE);
        e.add(Enchantment.ARROW_FIRE);
        e.add(Enchantment.ARROW_INFINITE);
        e.add(Enchantment.ARROW_KNOCKBACK);
        e.add(Enchantment.DAMAGE_ALL);
        e.add(Enchantment.DAMAGE_ARTHROPODS);
        e.add(Enchantment.DAMAGE_UNDEAD);
        e.add(Enchantment.DIG_SPEED);
        e.add(Enchantment.DURABILITY);
        e.add(Enchantment.FIRE_ASPECT);
        e.add(Enchantment.KNOCKBACK);
        e.add(Enchantment.LOOT_BONUS_BLOCKS);
        e.add(Enchantment.LOOT_BONUS_MOBS);
        e.add(Enchantment.LUCK);
        e.add(Enchantment.LURE);
        e.add(Enchantment.OXYGEN);
        e.add(Enchantment.PROTECTION_ENVIRONMENTAL);
        e.add(Enchantment.PROTECTION_EXPLOSIONS);
        e.add(Enchantment.PROTECTION_FALL);
        e.add(Enchantment.PROTECTION_FIRE);
        e.add(Enchantment.PROTECTION_PROJECTILE);
        e.add(Enchantment.SILK_TOUCH);
        e.add(Enchantment.THORNS);
        e.add(Enchantment.WATER_WORKER);
        return e;
    }
}

