/*
 * Decompiled with CFR 0.152.
 */
package me.Vextricity.sek.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import me.Vextricity.sek.Main;

public class FileUtils {
    Main plugin;
    public static HashMap<File, BufferedWriter> writers = new HashMap();

    public FileUtils(Main pl) {
        this.plugin = pl;
    }

    public BufferedWriter getBufferedWriter(File f) {
        try {
            if (writers.containsKey(f)) {
                return writers.get(f);
            }
            BufferedWriter returns = new BufferedWriter(new FileWriter(f, true));
            writers.put(f, returns);
            return returns;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void logToFile(File f, String message) {
        try {
            if (!f.exists()) {
                f.getParentFile().mkdirs();
                f.createNewFile();
            }
            BufferedWriter br = this.getBufferedWriter(f);
            br.write(message);
            br.newLine();
            br.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> readFile(File datafolder, String file) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            Scanner scanner = new Scanner(new File(datafolder, file));
            while (scanner.hasNextLine()) {
                list.add(scanner.nextLine());
            }
            scanner.close();
            return list;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    public void removeLineFromFile(String file, String lineToRemove) {
        try {
            File inFile = new File(file);
            if (!inFile.isFile()) {
                System.out.println("Parameter is not an existing file");
                return;
            }
            File tempFile = new File(String.valueOf(inFile.getAbsolutePath()) + ".tmp");
            BufferedReader br = new BufferedReader(new FileReader(file));
            PrintWriter pw = new PrintWriter(new FileWriter(tempFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.trim().equals(lineToRemove)) continue;
                pw.println(line);
                pw.flush();
            }
            pw.close();
            br.close();
            if (!inFile.delete()) {
                System.out.println("Could not delete file");
                return;
            }
            if (!tempFile.renameTo(inFile)) {
                System.out.println("Could not rename file");
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

