/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.statistics.utils;

import java.util.stream.Collectors;
import me.monoto.cmd.bukkit.BukkitCommandManager;
import me.monoto.cmd.bukkit.message.BukkitMessageKey;
import me.monoto.cmd.core.message.MessageKey;
import me.monoto.cmd.core.suggestion.SuggestionKey;
import me.monoto.statistics.Statistics;
import me.monoto.statistics.commands.AllPlayersCommand;
import me.monoto.statistics.commands.ForceUpdateCommand;
import me.monoto.statistics.commands.GlobalStatisticsCommand;
import me.monoto.statistics.commands.PlayerSearchCommand;
import me.monoto.statistics.commands.ReloadCommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class CommandManager {
    public static void setupCommandManager(Statistics plugin) {
        BukkitCommandManager<CommandSender> commandManager = BukkitCommandManager.create((Plugin)plugin);
        commandManager.registerSuggestion(SuggestionKey.of("online-players"), (sender, context) -> Bukkit.getServer().getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList()));
        commandManager.registerMessage(MessageKey.NOT_ENOUGH_ARGUMENTS, (sender, context) -> sender.sendMessage(MiniMessage.miniMessage().deserialize((Object)plugin.getLanguage().getString("error.invalid_usage", "<red>Invalid usage"))));
        commandManager.registerMessage(MessageKey.UNKNOWN_COMMAND, (sender, context) -> sender.sendMessage(MiniMessage.miniMessage().deserialize(plugin.getLanguage().getString("error.unknown_command", "<red>Unknown command"), (TagResolver)Placeholder.component((String)"cmd", (ComponentLike)Component.text("/stats " + context.getSubCommand())))));
        commandManager.registerMessage(BukkitMessageKey.NO_PERMISSION, (sender, context) -> sender.sendMessage(MiniMessage.miniMessage().deserialize(plugin.getLanguage().getString("error.no_permission", "<red>No permission"), (TagResolver)Placeholder.component((String)"permission", (ComponentLike)Component.text(context.getPermission())))));
        commandManager.registerCommand(new GlobalStatisticsCommand(plugin), new PlayerSearchCommand(plugin), new GlobalStatisticsCommand(plugin), new AllPlayersCommand(plugin), new ForceUpdateCommand(plugin), new ReloadCommand(plugin));
    }
}

