/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.statistics.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import me.monoto.statistics.stats.GlobalStatistics;
import me.monoto.statistics.stats.PlayerStatistics;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;

public class StatisticsManager {
    private static GlobalStatistics globalStatistics;
    public static HashMap<UUID, Object> offlinePlayerStatistics;
    public static HashMap<UUID, Object> playerStatistics;
    public static HashMap<String, LinkedHashMap<String, Integer>> topThreeStatistics;

    public static void setGlobalStatistics(int fished, int mined, int killed, int placed, int traversed) {
        GlobalStatistics stats = new GlobalStatistics();
        stats.setFishedFish(fished);
        stats.setMinedBlocks(mined);
        stats.setMobsKilled(killed);
        stats.setPlacedBlocks(placed);
        stats.setTraversedBlocks(traversed);
        globalStatistics = stats;
    }

    public static void setPlayerStatistics(UUID uuid, String name, int fished, int mined, int killed, int placed, int traversed) {
        StatisticsManager.setStatistics(uuid, name, fished, mined, killed, placed, traversed, playerStatistics);
    }

    public static void setOfflinePlayerStatistics(UUID uuid, String name, int fished, int mined, int killed, int placed, int traversed) {
        StatisticsManager.setStatistics(uuid, name, fished, mined, killed, placed, traversed, offlinePlayerStatistics);
    }

    private static void setStatistics(UUID uuid, String name, int fished, int mined, int killed, int placed, int traversed, HashMap<UUID, Object> hashmap) {
        PlayerStatistics stats = new PlayerStatistics();
        stats.setPlayerUUID(uuid);
        stats.setPlayerName(name);
        stats.setFishedFish(fished);
        stats.setMinedBlocks(mined);
        stats.setMobsKilled(killed);
        stats.setPlacedBlocks(placed);
        stats.setTraversedBlocks(traversed);
        hashmap.put(stats.getPlayerUUID(), stats);
    }

    public static void setTopThreeStatistics(HashMap<String, LinkedHashMap<String, Integer>> topThree) {
        topThreeStatistics = topThree;
    }

    public static GlobalStatistics getGlobalStatistics() {
        return globalStatistics;
    }

    public static HashMap<UUID, Object> getPlayerStatistics() {
        return playerStatistics;
    }

    public static HashMap<UUID, Object> getOfflinePlayerStatistics() {
        return offlinePlayerStatistics;
    }

    public static HashMap<String, LinkedHashMap<String, Integer>> getTopThreeStatistics() {
        return topThreeStatistics;
    }

    public static int getTotalBlocksTraversed(OfflinePlayer player) {
        ArrayList<Statistic> statistics = new ArrayList<Statistic>(Arrays.asList(Statistic.WALK_ONE_CM, Statistic.SPRINT_ONE_CM, Statistic.SWIM_ONE_CM, Statistic.WALK_ON_WATER_ONE_CM, Statistic.WALK_UNDER_WATER_ONE_CM, Statistic.CROUCH_ONE_CM, Statistic.BOAT_ONE_CM, Statistic.HORSE_ONE_CM, Statistic.MINECART_ONE_CM, Statistic.PIG_ONE_CM, Statistic.STRIDER_ONE_CM));
        AtomicInteger value = new AtomicInteger();
        statistics.forEach(statistic -> value.addAndGet((int)Math.floor(player.getStatistic(statistic)) / 100));
        return value.get();
    }

    public static int getTotalBlocks(OfflinePlayer player, Statistic statistic) {
        int count = 0;
        for (Material material : Material.values()) {
            if (!material.isBlock()) continue;
            try {
                count += player.getStatistic(statistic, material);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return count;
    }

    static {
        offlinePlayerStatistics = new HashMap();
        playerStatistics = new HashMap();
        topThreeStatistics = new HashMap();
    }
}

