/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.statistics.menus.submenus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import me.monoto.gui.builder.gui.PaginatedBuilder;
import me.monoto.gui.builder.item.ItemBuilder;
import me.monoto.gui.builder.item.SkullBuilder;
import me.monoto.gui.guis.Gui;
import me.monoto.gui.guis.GuiItem;
import me.monoto.gui.guis.PaginatedGui;
import me.monoto.statistics.Statistics;
import me.monoto.statistics.menus.GlobalMenu;
import me.monoto.statistics.menus.utils.Pagination;
import me.monoto.statistics.utils.Formatters;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.translation.Translatable;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class PlayerStatisticsMenuItems {
    public static void getItemPreview(String type, Player player, OfflinePlayer target) {
        PaginatedGui gui = ((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().title(Formatters.miniMulti(Formatters.lang().getString("gui.main.title-player", "<black><player> <type> stats"), List.of("player", "type"), List.of(Component.text(Formatters.getPossessionString(Objects.requireNonNull(target.getName()))), Component.text(type))))).rows(4)).pageSize(27).create();
        Pagination.getPaginatedUtil(gui, target, "player", type);
        gui.setItem(31, ((SkullBuilder)ItemBuilder.skull().owner(target).name(Formatters.mini(Formatters.lang().getString("gui.main.player_head.title", "<player>"), "player", Component.text(Formatters.getPossessionString(Objects.requireNonNull(target.getName())))).decoration(TextDecoration.ITALIC, false))).asGuiItem(event -> GlobalMenu.initialise((Player)event.getWhoClicked(), target)));
        switch (type) {
            case "fishing": {
                PlayerStatisticsMenuItems.getFish(gui, target);
                break;
            }
            case "killing": {
                PlayerStatisticsMenuItems.getKills(gui, target);
                break;
            }
            case "travelling": {
                PlayerStatisticsMenuItems.getMovements(gui, target);
                break;
            }
            case "mining": 
            case "placing": {
                PlayerStatisticsMenuItems.getBlocks(gui, type, target);
            }
        }
        gui.setDefaultClickAction(event -> event.setCancelled(true));
        gui.open((HumanEntity)player);
    }

    private static void getFish(PaginatedGui gui, OfflinePlayer target) {
        if (target != null && target.getPlayer() != null) {
            JSONParser parser = new JSONParser();
            try {
                JSONObject json = (JSONObject)parser.parse((String)target.getPlayer().getPersistentDataContainer().get(new NamespacedKey((Plugin)Statistics.getInstance(), "FISHING_STATS"), PersistentDataType.STRING));
                for (Object key : json.keySet()) {
                    ItemStack itemStack = new ItemStack(Material.valueOf((String)key.toString()), 1);
                    if (Objects.equals(key.toString(), "POTION")) {
                        itemStack = new ItemStack(Material.POTION, 1);
                        ItemMeta itemMeta = itemStack.getItemMeta();
                        PotionMeta potionMeta = (PotionMeta)itemMeta;
                        PotionData potionData = new PotionData(PotionType.WATER);
                        potionMeta.setBasePotionData(potionData);
                        itemStack.setItemMeta(itemMeta);
                    }
                    GuiItem item = ((ItemBuilder)ItemBuilder.from(itemStack).lore(Formatters.mini(Formatters.lang().getString("gui.main.fishing.lore", "<white>Total: <amount>"), "amount", Component.text(((Long)json.get(key)).intValue())).decoration(TextDecoration.ITALIC, false))).asGuiItem();
                    gui.addItem(item);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void getKills(PaginatedGui gui, OfflinePlayer target) {
        for (EntityType type : EntityType.values()) {
            try {
                Material material;
                if (target.getStatistic(Statistic.KILL_ENTITY, type) <= 0) continue;
                int statAmount = target.getStatistic(Statistic.KILL_ENTITY, type);
                try {
                    material = Material.valueOf((String)(type + "_SPAWN_EGG"));
                }
                catch (IllegalArgumentException exception) {
                    switch (type) {
                        case IRON_GOLEM: {
                            Material material2 = Material.IRON_INGOT;
                            break;
                        }
                        case SNOWMAN: {
                            Material material2 = Material.SNOWBALL;
                            break;
                        }
                        case WITHER: {
                            Material material2 = Material.WITHER_SKELETON_SKULL;
                            break;
                        }
                        default: {
                            Material material2 = material = null;
                        }
                    }
                }
                if (material == null) continue;
                GuiItem item = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(material).name(Component.translatable((Translatable)type).decoration(TextDecoration.ITALIC, false))).lore(Formatters.mini(Formatters.lang().getString("gui.main.killing.lore", "<white>Total: <amount>"), "amount", Component.text(statAmount)).decoration(TextDecoration.ITALIC, false))).asGuiItem();
                gui.addItem(item);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private static void getMovements(PaginatedGui gui, OfflinePlayer target) {
        ArrayList<String> itemNames = new ArrayList<String>(Arrays.asList("Distance Walked", "Distance Sprinted", "Distance Swum", "Distance Walked on Water", "Distance Walked under Water", "Distance Climbed", "Distance Crouched", "Distance Fallen", "Distance by Elytra", "Distance by Boat", "Distance by Horse", "Distance by Minecart", "Distance by Pig", "Distance by Strider", "Times Jumps"));
        ArrayList<Statistic> statistics = new ArrayList<Statistic>(Arrays.asList(Statistic.WALK_ONE_CM, Statistic.SPRINT_ONE_CM, Statistic.SWIM_ONE_CM, Statistic.WALK_ON_WATER_ONE_CM, Statistic.WALK_UNDER_WATER_ONE_CM, Statistic.CLIMB_ONE_CM, Statistic.CROUCH_ONE_CM, Statistic.FALL_ONE_CM, Statistic.AVIATE_ONE_CM, Statistic.BOAT_ONE_CM, Statistic.HORSE_ONE_CM, Statistic.MINECART_ONE_CM, Statistic.PIG_ONE_CM, Statistic.STRIDER_ONE_CM, Statistic.JUMP));
        ArrayList<Material> materials = new ArrayList<Material>(Arrays.asList(Material.LEATHER_BOOTS, Material.GOLDEN_BOOTS, Material.WATER_BUCKET, Material.ICE, Material.DIAMOND_HELMET, Material.LADDER, Material.LEATHER_BOOTS, Material.LINGERING_POTION, Material.ELYTRA, Material.OAK_BOAT, Material.DIAMOND_HORSE_ARMOR, Material.MINECART, Material.PIG_SPAWN_EGG, Material.STRIDER_SPAWN_EGG, Material.IRON_BOOTS));
        for (int index = 0; index < itemNames.size(); ++index) {
            int statAmount = target.getStatistic(Statistic.JUMP);
            if (statistics.get(index) != Statistic.JUMP) {
                statAmount = (int)Math.floor(target.getStatistic(statistics.get(index))) / 100;
            }
            GuiItem item = ((ItemBuilder)((ItemBuilder)((ItemBuilder)ItemBuilder.from(materials.get(index)).lore(Formatters.mini(Formatters.lang().getString("gui.main.killing.lore", "<white>Total: <amount>"), "amount", Component.text(statAmount)).decoration(TextDecoration.ITALIC, false))).flags(ItemFlag.HIDE_POTION_EFFECTS)).name(((TextComponent)Component.text(itemNames.get(index)).color(NamedTextColor.WHITE)).decoration(TextDecoration.ITALIC, false))).asGuiItem();
            gui.addItem(item);
        }
    }

    private static void getBlocks(PaginatedGui gui, String type, OfflinePlayer target) {
        Statistic statistic = Objects.equals(type, "mining") ? Statistic.MINE_BLOCK : Statistic.USE_ITEM;
        String typeLore = Objects.equals(type, "mining") ? "gui.main.mining.lore" : "gui.main.placing.lore";
        for (Material material : Material.values()) {
            if (target.getStatistic(statistic, material) <= 0 || !material.isBlock()) continue;
            int statAmount = target.getStatistic(statistic, material);
            GuiItem item = ((ItemBuilder)ItemBuilder.from(material).lore(Formatters.mini(Formatters.lang().getString(typeLore, "<white>Total: <amount>"), "amount", Component.text(statAmount)).decoration(TextDecoration.ITALIC, false))).asGuiItem();
            gui.addItem(item);
        }
    }
}

