/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.statistics.menus;

import java.util.UUID;
import me.monoto.gui.builder.gui.PaginatedBuilder;
import me.monoto.gui.builder.item.ItemBuilder;
import me.monoto.gui.builder.item.SkullBuilder;
import me.monoto.gui.guis.Gui;
import me.monoto.gui.guis.GuiItem;
import me.monoto.gui.guis.PaginatedGui;
import me.monoto.statistics.menus.GlobalMenu;
import me.monoto.statistics.menus.utils.Pagination;
import me.monoto.statistics.stats.PlayerStatistics;
import me.monoto.statistics.stats.StatisticsManager;
import me.monoto.statistics.utils.Formatters;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public class PlayerListMenu {
    public static void initialise(Player player) {
        PaginatedGui gui = ((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().title(Formatters.mini(Formatters.lang().getString("gui.main.title_player_list", "<black>Player List"), "page", Component.text(1)))).rows(4)).pageSize(27).create();
        PlayerListMenu.populateMenu(gui);
        gui.setDefaultClickAction(event -> event.setCancelled(true));
        gui.open((HumanEntity)player);
    }

    public static void populateMenu(PaginatedGui gui) {
        Pagination.getPaginatedUtil(gui, null, "player-list", "none");
        gui.setItem(31, ((ItemBuilder)ItemBuilder.from(Material.CHEST).name(((TextComponent)Component.text("Global Statistics").color(NamedTextColor.WHITE)).decoration(TextDecoration.ITALIC, false))).asGuiItem(event -> GlobalMenu.initialise((Player)event.getWhoClicked())));
        if (!StatisticsManager.getPlayerStatistics().isEmpty()) {
            Bukkit.getOnlinePlayers().forEach(player -> {
                PlayerStatistics stats = (PlayerStatistics)StatisticsManager.getPlayerStatistics().get(player.getUniqueId());
                GuiItem item = ((SkullBuilder)ItemBuilder.skull().owner((OfflinePlayer)player).name(Formatters.getPlayerSkullTitle((OfflinePlayer)player).decoration(TextDecoration.ITALIC, false))).asGuiItem(event -> {
                    if (Bukkit.getPlayer((UUID)stats.getPlayerUUID()) == null) {
                        PlayerListMenu.initialise((Player)event.getWhoClicked());
                    } else {
                        GlobalMenu.initialise((Player)event.getWhoClicked(), (OfflinePlayer)player);
                    }
                });
                gui.addItem(item);
            });
        }
    }
}

