/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.statistics.database;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import me.monoto.statistics.Statistics;
import me.monoto.statistics.database.DatabaseManager;

public class DatabaseClass {
    private static Statistics plugin;

    public DatabaseClass(Statistics main) {
        plugin = main;
        DatabaseClass.createDatabase();
    }

    public static Connection connect() {
        String url = "jdbc:sqlite:" + DatabaseClass.getFile();
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(url);
        }
        catch (SQLException exception) {
            exception.printStackTrace();
        }
        return connection;
    }

    private static void createDatabase() {
        if (!plugin.getDataFolder().mkdirs()) {
            if (!DatabaseClass.getFile().exists()) {
                try (Connection connection = DatabaseClass.connect();){
                    if (connection != null) {
                        System.out.println("[GlobalStats] Database has been created.");
                    }
                }
                catch (SQLException exception) {
                    exception.printStackTrace();
                }
            }
            DatabaseClass.createTable();
            DatabaseManager.getAllStatistics();
            DatabaseManager.getTopThreeStatistics();
        }
    }

    private static void createTable() {
        String bountySQL = "CREATE TABLE IF NOT EXISTS `player_statistics` (`uuid` VARCHAR(100) PRIMARY KEY, `name` VARCHAR(16) NOT NULL, `fished` INTEGER NOT NULL, `mined` INTEGER NOT NULL, `killed` INTEGER NOT NULL, `placed` INTEGER NOT NULL, `traversed` INTEGER NOT NULL)";
        try (Connection connection = DatabaseClass.connect();
             Statement statement = connection.createStatement();){
            statement.execute(bountySQL);
        }
        catch (SQLException exception) {
            exception.printStackTrace();
        }
    }

    public static void query(String sql) {
        try (Connection connection = DatabaseClass.connect();
             Statement statement = connection.createStatement();){
            statement.executeUpdate(sql);
        }
        catch (SQLException exception) {
            exception.printStackTrace();
        }
    }

    private static File getFile() {
        return new File(plugin.getDataFolder(), "statistics.db");
    }
}

