/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.statistics;

import java.util.Objects;
import me.monoto.bukkit.Metrics;
import me.monoto.statistics.database.DatabaseClass;
import me.monoto.statistics.database.DatabaseManager;
import me.monoto.statistics.listeners.RouteEvent;
import me.monoto.statistics.listeners.StatsEvent;
import me.monoto.statistics.stats.PlayerStatistics;
import me.monoto.statistics.stats.StatisticsManager;
import me.monoto.statistics.utils.CommandManager;
import me.monoto.statistics.utils.LanguageManager;
import me.monoto.statistics.utils.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Statistics
extends JavaPlugin {
    private static Statistics instance;
    private String newVersion;
    private YamlConfiguration langFile;
    public DatabaseClass database;
    public Metrics metric;

    public static Statistics getInstance() {
        return instance;
    }

    public Statistics() {
        instance = this;
    }

    public void onEnable() {
        this.saveDefaultConfig();
        int bstatID = 15621;
        int spigotID = 103379;
        this.database = new DatabaseClass(this);
        this.metric = new Metrics(this, bstatID);
        this.setLanguage(new LanguageManager(this).getFileConfig());
        new RouteEvent(this);
        new StatsEvent(this);
        CommandManager.setupCommandManager(this);
        new UpdateChecker((Plugin)this, spigotID).getLatestVersion(version -> {
            if (!Objects.equals(this.getDescription().getVersion(), version)) {
                this.getLogger().info("GlobalStats v" + version + " is out! Download it at: https://www.spigotmc.org/resources/globalstats.103379/");
                this.setVersion((String)version);
            } else {
                this.getLogger().info("No new version available");
            }
        });
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            if (!Bukkit.getOnlinePlayers().isEmpty()) {
                this.getServer().getOnlinePlayers().forEach(player -> DatabaseManager.updatePlayer(player.getUniqueId()));
                DatabaseManager.getAllStatistics();
                DatabaseManager.getTopThreeStatistics();
            }
        }, 1L, 6000L);
    }

    public void onDisable() {
        StatisticsManager.getPlayerStatistics().forEach((key, value) -> {
            PlayerStatistics stats = (PlayerStatistics)value;
            DatabaseManager.updatePlayer(stats.getPlayerUUID());
        });
        this.getLogger().info(" has successfully shut down, and has saved " + StatisticsManager.getPlayerStatistics().size() + " players data.");
    }

    public String getVersion() {
        return this.newVersion;
    }

    public void setVersion(String value) {
        this.newVersion = value;
    }

    public YamlConfiguration getLanguage() {
        return this.langFile;
    }

    public void setLanguage(YamlConfiguration value) {
        this.langFile = value;
    }
}

