/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.gui.guis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.monoto.gui.components.Serializable;
import me.monoto.gui.guis.GuiItem;
import me.monoto.gui.guis.PaginatedGui;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

class PersistentPaginatedGui
extends PaginatedGui
implements Serializable {
    private final List<Page> pages = new ArrayList<Page>();
    private final YamlConfiguration yamlConfiguration = new YamlConfiguration();

    public PersistentPaginatedGui(int rows, int pageSize, @NotNull String title, int pages) {
        super(rows, pageSize, title);
        if (pages <= 0) {
            this.pages.add(new Page());
            return;
        }
        for (int i = 0; i < pages; ++i) {
            this.pages.add(new Page());
        }
    }

    public PersistentPaginatedGui(@NotNull String title) {
        this(1, title);
    }

    public PersistentPaginatedGui(int rows, @NotNull String title) {
        this(rows, 0, title, 1);
    }

    public PersistentPaginatedGui(@NotNull String title, int pages) {
        this(1, 0, title, pages);
    }

    public PersistentPaginatedGui(int rows, @NotNull String title, int pages) {
        this(rows, 0, title, pages);
    }

    @NotNull
    public @NotNull Map<@NotNull Integer, @NotNull ItemStack> addItem(ItemStack ... items) {
        return this.addItem(1, items);
    }

    @NotNull
    public @NotNull Map<@NotNull Integer, @NotNull ItemStack> addItem(int page, ItemStack ... items) {
        int finalPage = page;
        if (page <= 0 || page > this.pages.size()) {
            finalPage = 1;
        }
        return Collections.unmodifiableMap(this.getInventory().addItem(items));
    }

    @Override
    public void open(@NotNull HumanEntity player) {
        this.open(player, 1);
    }

    @Override
    public void open(@NotNull HumanEntity player, int openPage) {
        if (player.isSleeping()) {
            return;
        }
        if (openPage < this.pages.size() || openPage > 0) {
            this.setPageNum(openPage - 1);
        }
        this.getInventory().clear();
        this.populateGui();
        if (this.getPageSize() == 0) {
            this.setPageSize(this.calculatePageSize());
        }
        this.pages.get(this.getPageNum()).populatePage(this.getInventory());
        player.openInventory(this.getInventory());
    }

    @Override
    public boolean next() {
        if (this.getPageNum() + 1 >= this.pages.size()) {
            return false;
        }
        this.savePage();
        this.setPageNum(this.getPageNum() + 1);
        this.updatePage();
        return true;
    }

    @Override
    public boolean previous() {
        if (this.getPageNum() - 1 < 0) {
            return false;
        }
        this.savePage();
        this.setPageNum(this.getPageNum() - 1);
        this.updatePage();
        return true;
    }

    @Override
    public int getCurrentPageNum() {
        return this.getPageNum() + 1;
    }

    @Override
    void updatePage() {
        this.clearPage();
        this.populatePage();
    }

    @Override
    void clearPage() {
        for (int i = 0; i < this.getInventory().getSize(); ++i) {
            ItemStack itemStack = this.getInventory().getItem(i);
            if (itemStack == null || this.getGuiItems().get(i) != null) continue;
            this.getInventory().setItem(i, null);
        }
    }

    void savePage() {
        this.pages.get(this.getPageNum()).savePage(this.getInventory(), this.getGuiItems());
    }

    private void populatePage() {
        this.pages.get(this.getPageNum()).populatePage(this.getInventory());
    }

    @Override
    @NotNull
    public List<String> encodeGui() {
        int inventorySize = this.getInventory().getSize();
        ArrayList<String> pageItems = new ArrayList<String>();
        for (Page page : this.pages) {
            this.yamlConfiguration.set("inventory", (Object)page.getContent(inventorySize));
        }
        return pageItems;
    }

    @Override
    public void decodeGui(@NotNull List<String> encodedItem) {
        for (int i = 0; i < this.pages.size(); ++i) {
            Page page = this.pages.get(i);
            List content = (List)this.yamlConfiguration.get("inventory");
            if (content == null) continue;
            page.loadPageContent(content, this.getInventory().getSize());
        }
    }

    private static class Page {
        private final Map<Integer, ItemStack> pageItems = new LinkedHashMap<Integer, ItemStack>();

        private Page() {
        }

        private void populatePage(@NotNull Inventory inventory) {
            for (Map.Entry<Integer, ItemStack> entry : this.pageItems.entrySet()) {
                inventory.setItem(entry.getKey().intValue(), entry.getValue());
            }
        }

        private void savePage(@NotNull Inventory inventory, @NotNull Map<Integer, GuiItem> guiItems) {
            for (int i = 0; i < inventory.getSize(); ++i) {
                ItemStack itemStack = inventory.getItem(i);
                if (itemStack == null) {
                    this.pageItems.remove(i);
                    continue;
                }
                if (guiItems.get(i) != null) continue;
                this.pageItems.put(i, itemStack);
            }
        }

        @NotNull
        private ItemStack[] getContent(int inventorySize) {
            ItemStack[] content = new ItemStack[inventorySize];
            for (int i = 0; i < inventorySize; ++i) {
                content[i] = this.pageItems.get(i);
            }
            return content;
        }

        private void loadPageContent(@NotNull List<ItemStack> items, int inventorySize) {
            this.pageItems.clear();
            for (int i = 0; i < inventorySize; ++i) {
                ItemStack item = items.get(i);
                if (item == null) continue;
                this.pageItems.put(i, item);
            }
        }
    }
}

