/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.gui.builder.gui;

import java.util.function.Consumer;
import me.monoto.gui.builder.gui.BaseGuiBuilder;
import me.monoto.gui.components.ScrollType;
import me.monoto.gui.components.util.Legacy;
import me.monoto.gui.guis.ScrollingGui;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ScrollingBuilder
extends BaseGuiBuilder<ScrollingGui, ScrollingBuilder> {
    private ScrollType scrollType;
    private int pageSize = -1;

    public ScrollingBuilder(@NotNull ScrollType scrollType) {
        this.scrollType = scrollType;
    }

    @NotNull
    @Contract(value="_ -> this")
    public ScrollingBuilder scrollType(@NotNull ScrollType scrollType) {
        this.scrollType = scrollType;
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public ScrollingBuilder pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    @NotNull
    @Contract(value=" -> new")
    public ScrollingGui create() {
        ScrollingGui gui = new ScrollingGui(this.getRows(), this.pageSize, Legacy.SERIALIZER.serialize(this.getTitle()), this.scrollType, this.getModifiers());
        Consumer consumer = this.getConsumer();
        if (consumer != null) {
            consumer.accept(gui);
        }
        return gui;
    }
}

