/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.core.requirement;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import me.monoto.cmd.core.registry.RegistryKey;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class RequirementKey
extends RegistryKey {
    private static final Set<RequirementKey> REGISTERED_KEYS = new HashSet<RequirementKey>();

    private RequirementKey(@NotNull String key) {
        super(key);
        REGISTERED_KEYS.add(this);
    }

    @NotNull
    @Contract(value="_ -> new")
    public static RequirementKey of(@NotNull String key) {
        return new RequirementKey(key);
    }

    @NotNull
    public static Set<RequirementKey> getRegisteredKeys() {
        return Collections.unmodifiableSet(REGISTERED_KEYS);
    }

    @Override
    public String toString() {
        return "RequirementKey{super=" + super.toString() + "}";
    }
}

