/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.core.requirement;

import java.util.Objects;
import me.monoto.cmd.core.message.ContextualKey;
import me.monoto.cmd.core.message.MessageRegistry;
import me.monoto.cmd.core.message.context.MessageContext;
import me.monoto.cmd.core.message.context.MessageContextFactory;
import me.monoto.cmd.core.requirement.RequirementResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Requirement<S, C extends MessageContext> {
    private final RequirementResolver<S> resolver;
    private final ContextualKey<C> messageKey;
    private final MessageContextFactory<C> contextFactory;
    private final boolean invert;

    public Requirement(@NotNull RequirementResolver<S> resolver, @Nullable ContextualKey<C> messageKey, @NotNull MessageContextFactory<C> contextFactory, boolean invert) {
        this.resolver = resolver;
        this.messageKey = messageKey;
        this.contextFactory = contextFactory;
        this.invert = invert;
    }

    @Nullable
    public ContextualKey<C> getMessageKey() {
        return this.messageKey;
    }

    public <ST> void sendMessage(@NotNull MessageRegistry<ST> registry, @NotNull ST sender, @NotNull String command, @NotNull String subCommand) {
        if (this.messageKey == null) {
            return;
        }
        registry.sendMessage(this.messageKey, sender, this.contextFactory.create(command, subCommand));
    }

    public boolean isMet(@NotNull S sender) {
        return this.resolver.resolve(sender) != this.invert;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Requirement that = (Requirement)o;
        return this.resolver.equals(that.resolver) && Objects.equals(this.messageKey, that.messageKey);
    }

    public int hashCode() {
        return Objects.hash(this.resolver, this.messageKey);
    }

    public String toString() {
        return "Requirement{resolver=" + this.resolver + ", messageKey=" + this.messageKey + '}';
    }
}

