/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.core.processor;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import me.monoto.cmd.core.BaseCommand;
import me.monoto.cmd.core.annotation.ArgDescriptions;
import me.monoto.cmd.core.annotation.ArgName;
import me.monoto.cmd.core.annotation.Async;
import me.monoto.cmd.core.annotation.CommandFlags;
import me.monoto.cmd.core.annotation.Default;
import me.monoto.cmd.core.annotation.Description;
import me.monoto.cmd.core.annotation.Flag;
import me.monoto.cmd.core.annotation.Join;
import me.monoto.cmd.core.annotation.NamedArguments;
import me.monoto.cmd.core.annotation.Optional;
import me.monoto.cmd.core.annotation.Requirements;
import me.monoto.cmd.core.annotation.Split;
import me.monoto.cmd.core.annotation.SubCommand;
import me.monoto.cmd.core.annotation.Suggestion;
import me.monoto.cmd.core.annotation.Suggestions;
import me.monoto.cmd.core.argument.ArgumentRegistry;
import me.monoto.cmd.core.argument.ArgumentResolver;
import me.monoto.cmd.core.argument.CollectionInternalArgument;
import me.monoto.cmd.core.argument.EnumInternalArgument;
import me.monoto.cmd.core.argument.FlagInternalArgument;
import me.monoto.cmd.core.argument.InternalArgument;
import me.monoto.cmd.core.argument.JoinedStringInternalArgument;
import me.monoto.cmd.core.argument.LimitlessInternalArgument;
import me.monoto.cmd.core.argument.NamedInternalArgument;
import me.monoto.cmd.core.argument.ResolverInternalArgument;
import me.monoto.cmd.core.argument.SplitStringInternalArgument;
import me.monoto.cmd.core.argument.StringInternalArgument;
import me.monoto.cmd.core.argument.named.Argument;
import me.monoto.cmd.core.argument.named.ArgumentKey;
import me.monoto.cmd.core.argument.named.Arguments;
import me.monoto.cmd.core.argument.named.ListArgument;
import me.monoto.cmd.core.argument.named.NamedArgumentRegistry;
import me.monoto.cmd.core.exceptions.SubCommandRegistrationException;
import me.monoto.cmd.core.flag.Flags;
import me.monoto.cmd.core.flag.internal.FlagGroup;
import me.monoto.cmd.core.flag.internal.FlagOptions;
import me.monoto.cmd.core.flag.internal.FlagValidator;
import me.monoto.cmd.core.message.MessageKey;
import me.monoto.cmd.core.message.MessageRegistry;
import me.monoto.cmd.core.message.context.DefaultMessageContext;
import me.monoto.cmd.core.message.context.MessageContext;
import me.monoto.cmd.core.registry.RegistryContainer;
import me.monoto.cmd.core.requirement.Requirement;
import me.monoto.cmd.core.requirement.RequirementKey;
import me.monoto.cmd.core.requirement.RequirementRegistry;
import me.monoto.cmd.core.requirement.RequirementResolver;
import me.monoto.cmd.core.sender.SenderValidator;
import me.monoto.cmd.core.suggestion.EmptySuggestion;
import me.monoto.cmd.core.suggestion.EnumSuggestion;
import me.monoto.cmd.core.suggestion.SimpleSuggestion;
import me.monoto.cmd.core.suggestion.SuggestionKey;
import me.monoto.cmd.core.suggestion.SuggestionRegistry;
import me.monoto.cmd.core.suggestion.SuggestionResolver;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSubCommandProcessor<S> {
    private final BaseCommand baseCommand;
    private final String parentName;
    private final Method method;
    private String name = null;
    private String description = "No description provided.";
    private final List<String> argDescriptions = new ArrayList<String>();
    private final List<String> alias = new ArrayList<String>();
    private boolean isDefault = false;
    private final boolean isAsync;
    private Class<? extends S> senderType;
    private final FlagGroup<S> flagGroup = new FlagGroup();
    private final List<me.monoto.cmd.core.suggestion.Suggestion<S>> suggestionList = new ArrayList<me.monoto.cmd.core.suggestion.Suggestion<S>>();
    private final List<InternalArgument<S, ?>> internalArguments = new ArrayList();
    private final Set<Requirement<S, ?>> requirements = new HashSet();
    private final SuggestionRegistry<S> suggestionRegistry;
    private final ArgumentRegistry<S> argumentRegistry;
    private final NamedArgumentRegistry<S> namedArgumentRegistry;
    private final RequirementRegistry<S> requirementRegistry;
    private final MessageRegistry<S> messageRegistry;
    private final SenderValidator<S> senderValidator;
    private static final Set<Class<?>> COLLECTIONS = new HashSet<Class>(Arrays.asList(List.class, Set.class));

    protected AbstractSubCommandProcessor(@NotNull BaseCommand baseCommand, @NotNull String parentName, @NotNull Method method, @NotNull RegistryContainer<S> registryContainer, @NotNull SenderValidator<S> senderValidator) {
        this.baseCommand = baseCommand;
        this.parentName = parentName;
        this.method = method;
        this.suggestionRegistry = registryContainer.getSuggestionRegistry();
        this.argumentRegistry = registryContainer.getArgumentRegistry();
        this.namedArgumentRegistry = registryContainer.getNamedArgumentRegistry();
        this.requirementRegistry = registryContainer.getRequirementRegistry();
        this.messageRegistry = registryContainer.getMessageRegistry();
        this.senderValidator = senderValidator;
        this.isAsync = method.isAnnotationPresent(Async.class);
        this.extractSubCommandNames();
        if (this.name == null) {
            return;
        }
        this.extractFlags();
        this.extractRequirements();
        this.extractDescription();
        this.extractArgDescriptions();
        this.extractSuggestions();
        this.extractArguments(method);
        this.validateArguments();
    }

    protected void extractArguments(@NotNull Method method) {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (i == 0) {
                this.validateSender(parameter.getType());
                continue;
            }
            this.createArgument(parameter, i - 1);
        }
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public Class<? extends S> getSenderType() {
        if (this.senderType == null) {
            throw this.createException("Sender type could not be found.");
        }
        return this.senderType;
    }

    @NotNull
    public List<String> getAlias() {
        return this.alias;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    @NotNull
    public BaseCommand getBaseCommand() {
        return this.baseCommand;
    }

    @NotNull
    public Method getMethod() {
        return this.method;
    }

    @NotNull
    public Set<Requirement<S, ?>> getRequirements() {
        return this.requirements;
    }

    @NotNull
    public MessageRegistry<S> getMessageRegistry() {
        return this.messageRegistry;
    }

    @NotNull
    public SenderValidator<S> getSenderValidator() {
        return this.senderValidator;
    }

    @NotNull
    @Contract(value="_ -> new")
    protected SubCommandRegistrationException createException(@NotNull String message) {
        return new SubCommandRegistrationException(message, this.method, this.baseCommand.getClass());
    }

    protected void validateSender(@NotNull Class<?> type) {
        Set<Class<S>> allowedSenders = this.senderValidator.getAllowedSenders();
        if (allowedSenders.contains(type)) {
            this.senderType = type;
            return;
        }
        throw this.createException("\"" + type.getSimpleName() + "\" is not a valid sender. Sender must be one of the following: " + allowedSenders.stream().map(it -> "\"" + it.getSimpleName() + "\"").collect(Collectors.joining(", ")));
    }

    @NotNull
    public List<InternalArgument<S, ?>> getArguments() {
        return this.internalArguments;
    }

    protected void createArgument(@NotNull Parameter parameter, int position) {
        Class<?> type = parameter.getType();
        String argumentName = this.getArgName(parameter);
        String argumentDescription = this.getArgumentDescription(parameter, position);
        boolean optional = parameter.isAnnotationPresent(Optional.class);
        if (COLLECTIONS.stream().anyMatch(it -> it.isAssignableFrom(type))) {
            Class<?> collectionType = this.getGenericType(parameter);
            InternalArgument<S, String> internalArgument = this.createSimpleArgument(collectionType, argumentName, argumentDescription, this.suggestionList.get(position), 0, true);
            if (parameter.isAnnotationPresent(Split.class)) {
                Split splitAnnotation = parameter.getAnnotation(Split.class);
                this.addArgument(new SplitStringInternalArgument<S>(argumentName, argumentDescription, splitAnnotation.value(), internalArgument, type, this.suggestionList.get(position), position, optional));
                return;
            }
            this.addArgument(new CollectionInternalArgument<S>(argumentName, argumentDescription, internalArgument, type, this.suggestionList.get(position), position, optional));
            return;
        }
        if (type == String.class && parameter.isAnnotationPresent(Join.class)) {
            Join joinAnnotation = parameter.getAnnotation(Join.class);
            this.addArgument(new JoinedStringInternalArgument<S>(argumentName, argumentDescription, joinAnnotation.value(), this.suggestionList.get(position), position, optional));
            return;
        }
        if (type == Flags.class) {
            if (this.flagGroup.isEmpty()) {
                throw this.createException("Flags internalArgument detected but no flag annotation declared");
            }
            this.addArgument(new FlagInternalArgument<S>(argumentName, argumentDescription, this.flagGroup, position, optional));
            return;
        }
        if (type == Arguments.class) {
            NamedArguments namedArguments = this.method.getAnnotation(NamedArguments.class);
            if (namedArguments == null) {
                throw this.createException("TODO");
            }
            this.addArgument(new NamedInternalArgument<S>(argumentName, argumentDescription, this.collectNamedArgs(namedArguments.value()), position, optional));
            return;
        }
        this.addArgument(this.createSimpleArgument(type, argumentName, argumentDescription, this.suggestionList.get(position), position, optional));
    }

    private Map<String, InternalArgument<S, ?>> collectNamedArgs(String key) {
        List<Argument> arguments = this.namedArgumentRegistry.getResolver(ArgumentKey.of(key));
        if (arguments == null || arguments.isEmpty()) {
            throw this.createException("No registered named arguments found for key \"" + key + "\"");
        }
        return arguments.stream().map(argument -> {
            me.monoto.cmd.core.suggestion.Suggestion<S> suggestion = this.createSuggestion(argument.getSuggestion(), argument.getType());
            if (argument instanceof ListArgument) {
                ListArgument listArgument = (ListArgument)argument;
                InternalArgument<S, String> internalArgument = this.createSimpleArgument(listArgument.getType(), listArgument.getName(), listArgument.getDescription(), suggestion, 0, true);
                return Maps.immutableEntry((Object)listArgument.getName(), new SplitStringInternalArgument<S>(listArgument.getName(), listArgument.getDescription(), listArgument.getSeparator(), internalArgument, listArgument.getType(), suggestion, 0, true));
            }
            return Maps.immutableEntry((Object)argument.getName(), this.createSimpleArgument(argument.getType(), argument.getName(), argument.getDescription(), suggestion, 0, true));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @NotNull
    private String getArgName(@NotNull Parameter parameter) {
        if (parameter.isAnnotationPresent(ArgName.class)) {
            return parameter.getAnnotation(ArgName.class).value();
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, parameter.getName());
    }

    @NotNull
    private String getArgumentDescription(@NotNull Parameter parameter, int index) {
        Description description = parameter.getAnnotation(Description.class);
        if (description != null) {
            return description.value();
        }
        if (index < this.argDescriptions.size()) {
            return this.argDescriptions.get(index);
        }
        return "No description provided.";
    }

    private InternalArgument<S, String> createSimpleArgument(@NotNull Class<?> type, @NotNull String parameterName, @NotNull String argumentDescription, @NotNull me.monoto.cmd.core.suggestion.Suggestion<S> suggestion, int position, boolean optional) {
        ArgumentResolver<S> resolver = this.argumentRegistry.getResolver(type);
        if (resolver == null) {
            if (Enum.class.isAssignableFrom(type)) {
                return new EnumInternalArgument<S>(parameterName, argumentDescription, (Class<Enum<?>>)type, suggestion, position, optional);
            }
            throw this.createException("No internalArgument of type \"" + type.getName() + "\" registered");
        }
        return new ResolverInternalArgument<S>(parameterName, argumentDescription, type, resolver, suggestion, position, optional);
    }

    protected void addRequirement(@NotNull Requirement<S, ?> requirement) {
        this.requirements.add(requirement);
    }

    private void addArgument(@NotNull InternalArgument<S, ?> internalArgument) {
        this.internalArguments.add(internalArgument);
    }

    private void extractSubCommandNames() {
        Default defaultAnnotation = this.method.getAnnotation(Default.class);
        SubCommand subCommandAnnotation = this.method.getAnnotation(SubCommand.class);
        if (defaultAnnotation == null && subCommandAnnotation == null) {
            return;
        }
        if (defaultAnnotation != null) {
            this.name = "TH_DEFAULT";
            this.alias.addAll(Arrays.stream(defaultAnnotation.alias()).map(String::toLowerCase).collect(Collectors.toList()));
            this.isDefault = true;
            return;
        }
        this.name = subCommandAnnotation.value().toLowerCase();
        this.alias.addAll(Arrays.stream(subCommandAnnotation.alias()).map(String::toLowerCase).collect(Collectors.toList()));
        if (this.name.isEmpty()) {
            throw this.createException("@" + SubCommand.class.getSimpleName() + " name must not be empty");
        }
    }

    private void extractFlags() {
        List<Flag> flags = this.getFlagsFromAnnotations();
        if (flags.isEmpty()) {
            return;
        }
        for (Flag flagAnnotation : flags) {
            String flag = flagAnnotation.flag();
            if (flag.isEmpty()) {
                flag = null;
            }
            FlagValidator.validate(flag, this.method, this.baseCommand);
            String longFlag = flagAnnotation.longFlag();
            if (longFlag.contains(" ")) {
                throw this.createException("@" + Flag.class.getSimpleName() + "'s identifiers must not contain spaces");
            }
            if (longFlag.isEmpty()) {
                longFlag = null;
            }
            Class<?> argumentType = flagAnnotation.argument();
            SuggestionKey suggestionKey = flagAnnotation.suggestion().isEmpty() ? null : SuggestionKey.of(flagAnnotation.suggestion());
            me.monoto.cmd.core.suggestion.Suggestion<S> suggestion = this.createSuggestion(suggestionKey, flagAnnotation.argument());
            StringInternalArgument internalArgument = null;
            if (argumentType != Void.TYPE) {
                if (Enum.class.isAssignableFrom(argumentType)) {
                    internalArgument = new EnumInternalArgument<S>(argumentType.getName(), "", (Class<Enum<?>>)argumentType, suggestion, 0, false);
                } else {
                    ArgumentResolver<S> resolver = this.argumentRegistry.getResolver(argumentType);
                    if (resolver == null) {
                        throw this.createException("@" + Flag.class.getSimpleName() + "'s internalArgument contains unregistered type \"" + argumentType.getName() + "\"");
                    }
                    internalArgument = new ResolverInternalArgument<S>(argumentType.getName(), "", argumentType, resolver, suggestion, 0, false);
                }
            }
            this.flagGroup.addFlag(new FlagOptions(flag, longFlag, internalArgument));
        }
    }

    private List<Flag> getFlagsFromAnnotations() {
        CommandFlags flags = this.method.getAnnotation(CommandFlags.class);
        if (flags != null) {
            return Arrays.asList(flags.value());
        }
        Flag flag = this.method.getAnnotation(Flag.class);
        if (flag == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(flag);
    }

    public void extractRequirements() {
        for (me.monoto.cmd.core.annotation.Requirement requirementAnnotation : this.getRequirementsFromAnnotations()) {
            RequirementKey requirementKey = RequirementKey.of(requirementAnnotation.value());
            String messageKeyValue = requirementAnnotation.messageKey();
            MessageKey<MessageContext> messageKey = messageKeyValue.isEmpty() ? null : MessageKey.of(messageKeyValue, MessageContext.class);
            RequirementResolver<S> resolver = this.requirementRegistry.getRequirement(requirementKey);
            if (resolver == null) {
                throw this.createException("Could not find Requirement Key \"" + requirementKey.getKey() + "\"");
            }
            this.addRequirement(new Requirement<S, MessageContext>(resolver, messageKey, DefaultMessageContext::new, requirementAnnotation.invert()));
        }
    }

    private List<me.monoto.cmd.core.annotation.Requirement> getRequirementsFromAnnotations() {
        Requirements requirements = this.method.getAnnotation(Requirements.class);
        if (requirements != null) {
            return Arrays.asList(requirements.value());
        }
        me.monoto.cmd.core.annotation.Requirement requirement = this.method.getAnnotation(me.monoto.cmd.core.annotation.Requirement.class);
        if (requirement == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(requirement);
    }

    protected List<BiConsumer<Boolean, InternalArgument<S, ?>>> getArgValidations() {
        return Arrays.asList(this.validateOptionals(), this.validateLimitless());
    }

    private void validateArguments() {
        List<BiConsumer<Boolean, InternalArgument<S, ?>>> validations = this.getArgValidations();
        Iterator iterator = this.internalArguments.iterator();
        while (iterator.hasNext()) {
            InternalArgument internalArgument = iterator.next();
            validations.forEach(consumer -> consumer.accept(iterator.hasNext(), internalArgument));
        }
    }

    protected BiConsumer<Boolean, InternalArgument<S, ?>> validateOptionals() {
        return (hasNext, internalArgument) -> {
            if (hasNext.booleanValue() && internalArgument.isOptional()) {
                throw this.createException("Optional internalArgument is only allowed as the last internalArgument");
            }
        };
    }

    protected BiConsumer<Boolean, InternalArgument<S, ?>> validateLimitless() {
        return (hasNext, internalArgument) -> {
            if (hasNext.booleanValue() && internalArgument instanceof LimitlessInternalArgument) {
                throw this.createException("Limitless internalArgument is only allowed as the last internalArgument");
            }
        };
    }

    private void extractDescription() {
        Description description = this.method.getAnnotation(Description.class);
        if (description == null) {
            return;
        }
        this.description = description.value();
    }

    private void extractArgDescriptions() {
        ArgDescriptions argDescriptions = this.method.getAnnotation(ArgDescriptions.class);
        if (argDescriptions == null) {
            return;
        }
        this.argDescriptions.addAll(Arrays.asList(argDescriptions.value()));
    }

    public void extractSuggestions() {
        for (Suggestion suggestion : this.getSuggestionsFromAnnotations()) {
            String key = suggestion.value();
            if (key.isEmpty()) {
                this.suggestionList.add(new EmptySuggestion());
                continue;
            }
            SuggestionResolver<S> resolver = this.suggestionRegistry.getSuggestionResolver(SuggestionKey.of(key));
            if (resolver == null) {
                throw this.createException("Cannot find the suggestion key `" + key + "`");
            }
            this.suggestionList.add(new SimpleSuggestion<S>(resolver));
        }
        this.extractSuggestionFromParams();
    }

    private void extractSuggestionFromParams() {
        Parameter[] parameters = this.method.getParameters();
        for (int i = 1; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Suggestion suggestion = parameter.getAnnotation(Suggestion.class);
            SuggestionKey suggestionKey = suggestion == null ? null : SuggestionKey.of(suggestion.value());
            Class<?> type = this.getGenericType(parameter);
            int addIndex = i - 1;
            this.setOrAddSuggestion(addIndex, this.createSuggestion(suggestionKey, type));
        }
    }

    @NotNull
    private me.monoto.cmd.core.suggestion.Suggestion<S> createSuggestion(@Nullable SuggestionKey suggestionKey, @NotNull Class<?> type) {
        if (suggestionKey == null) {
            if (Enum.class.isAssignableFrom(type)) {
                return new EnumSuggestion(type);
            }
            SuggestionResolver<S> resolver = this.suggestionRegistry.getSuggestionResolver(type);
            if (resolver != null) {
                return new SimpleSuggestion<S>(resolver);
            }
            return new EmptySuggestion();
        }
        SuggestionResolver<S> resolver = this.suggestionRegistry.getSuggestionResolver(suggestionKey);
        if (resolver == null) {
            throw this.createException("Cannot find the suggestion key `" + suggestionKey + "`");
        }
        return new SimpleSuggestion<S>(resolver);
    }

    private void setOrAddSuggestion(int index, @Nullable me.monoto.cmd.core.suggestion.Suggestion<S> suggestion) {
        if (index >= this.suggestionList.size()) {
            if (suggestion == null) {
                this.suggestionList.add(new EmptySuggestion());
                return;
            }
            this.suggestionList.add(suggestion);
            return;
        }
        if (suggestion == null) {
            return;
        }
        this.suggestionList.set(index, suggestion);
    }

    private List<Suggestion> getSuggestionsFromAnnotations() {
        Suggestions requirements = this.method.getAnnotation(Suggestions.class);
        if (requirements != null) {
            return Arrays.asList(requirements.value());
        }
        Suggestion suggestion = this.method.getAnnotation(Suggestion.class);
        if (suggestion == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(suggestion);
    }

    private Class<?> getGenericType(@NotNull Parameter parameter) {
        Class<?> type = parameter.getType();
        if (COLLECTIONS.stream().anyMatch(it -> it.isAssignableFrom(type))) {
            ParameterizedType parameterizedType = (ParameterizedType)parameter.getParameterizedType();
            Type[] types = parameterizedType.getActualTypeArguments();
            if (types.length != 1) {
                throw this.createException("Unsupported collection type \"" + type + "\"");
            }
            Type genericType = types[0];
            return (Class)(genericType instanceof WildcardType ? ((WildcardType)genericType).getUpperBounds()[0] : genericType);
        }
        return type;
    }
}

