/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.core.processor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.monoto.cmd.core.BaseCommand;
import me.monoto.cmd.core.SubCommand;
import me.monoto.cmd.core.annotation.Command;
import me.monoto.cmd.core.annotation.Description;
import me.monoto.cmd.core.exceptions.CommandRegistrationException;
import me.monoto.cmd.core.execution.ExecutionProvider;
import me.monoto.cmd.core.processor.AbstractSubCommandProcessor;
import me.monoto.cmd.core.registry.RegistryContainer;
import me.monoto.cmd.core.sender.SenderMapper;
import me.monoto.cmd.core.sender.SenderValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCommandProcessor<SD, S, SC extends SubCommand<S>, P extends AbstractSubCommandProcessor<S>> {
    private final Class<?> annotatedClass;
    private String name;
    private String description = "No description provided.";
    private final List<String> alias = new ArrayList<String>();
    private final Map<String, SC> subCommands = new HashMap<String, SC>();
    private final Map<String, SC> subCommandsAlias = new HashMap<String, SC>();
    private final BaseCommand baseCommand;
    private final RegistryContainer<S> registryContainer;
    private final SenderMapper<SD, S> senderMapper;
    private final SenderValidator<S> senderValidator;
    private final ExecutionProvider syncExecutionProvider;
    private final ExecutionProvider asyncExecutionProvider;

    protected AbstractCommandProcessor(@NotNull BaseCommand baseCommand, @NotNull RegistryContainer<S> registryContainer, @NotNull SenderMapper<SD, S> senderMapper, @NotNull SenderValidator<S> senderValidator, @NotNull ExecutionProvider syncExecutionProvider, @NotNull ExecutionProvider asyncExecutionProvider) {
        this.baseCommand = baseCommand;
        this.registryContainer = registryContainer;
        this.senderMapper = senderMapper;
        this.senderValidator = senderValidator;
        this.syncExecutionProvider = syncExecutionProvider;
        this.asyncExecutionProvider = asyncExecutionProvider;
        this.annotatedClass = this.extractAnnotationClass();
        this.extractCommandNames();
        this.extractDescription();
        this.collectSubCommands();
    }

    private void collectSubCommands() {
        for (Method method : this.baseCommand.getClass().getDeclaredMethods()) {
            P processor;
            String subCommandName;
            if (Modifier.isPrivate(method.getModifiers()) || (subCommandName = ((AbstractSubCommandProcessor)(processor = this.createProcessor(method))).getName()) == null) continue;
            ExecutionProvider executionProvider = ((AbstractSubCommandProcessor)processor).isAsync() ? this.asyncExecutionProvider : this.syncExecutionProvider;
            SubCommand subCommand = this.subCommands.computeIfAbsent(subCommandName, it -> this.createSubCommand(processor, executionProvider));
            ((AbstractSubCommandProcessor)processor).getAlias().forEach(alias -> this.subCommandsAlias.putIfAbsent((String)alias, (SC)subCommand));
        }
    }

    @NotNull
    protected abstract P createProcessor(@NotNull Method var1);

    @Nullable
    protected abstract SC createSubCommand(@NotNull P var1, @NotNull ExecutionProvider var2);

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<String> getAlias() {
        return this.alias;
    }

    @NotNull
    public BaseCommand getBaseCommand() {
        return this.baseCommand;
    }

    public RegistryContainer<S> getRegistryContainer() {
        return this.registryContainer;
    }

    @NotNull
    public SenderMapper<SD, S> getSenderMapper() {
        return this.senderMapper;
    }

    @NotNull
    public SenderValidator<S> getSenderValidator() {
        return this.senderValidator;
    }

    public Map<String, SC> getSubCommands() {
        return this.subCommands;
    }

    public Map<String, SC> getSubCommandsAlias() {
        return this.subCommandsAlias;
    }

    public ExecutionProvider getSyncExecutionProvider() {
        return this.syncExecutionProvider;
    }

    public ExecutionProvider getAsyncExecutionProvider() {
        return this.asyncExecutionProvider;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    protected Class<?> getAnnotatedClass() {
        return this.annotatedClass;
    }

    private Class<?> extractAnnotationClass() {
        Class<?> commandClass = this.baseCommand.getClass();
        Class<?> parent = commandClass.getSuperclass();
        return parent != BaseCommand.class ? parent : commandClass;
    }

    private void extractCommandNames() {
        Command commandAnnotation = this.annotatedClass.getAnnotation(Command.class);
        if (commandAnnotation == null) {
            String commandName = this.baseCommand.getCommand();
            if (commandName == null) {
                throw new CommandRegistrationException("Command name or \"@" + Command.class.getSimpleName() + "\" annotation missing", this.baseCommand.getClass());
            }
            this.name = commandName;
            this.alias.addAll(this.baseCommand.getAlias());
        } else {
            this.name = commandAnnotation.value();
            Collections.addAll(this.alias, commandAnnotation.alias());
        }
        this.alias.addAll(this.baseCommand.getAlias());
        if (this.name.isEmpty()) {
            throw new CommandRegistrationException("Command name must not be empty", this.baseCommand.getClass());
        }
    }

    private void extractDescription() {
        Description description = this.annotatedClass.getAnnotation(Description.class);
        if (description == null) {
            return;
        }
        this.description = description.value();
    }
}

