/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.core.message;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import me.monoto.cmd.core.message.context.MessageContext;
import me.monoto.cmd.core.registry.RegistryKey;
import org.jetbrains.annotations.NotNull;

public abstract class ContextualKey<C extends MessageContext>
extends RegistryKey {
    private static final Set<ContextualKey<? extends MessageContext>> REGISTERED_KEYS = new HashSet<ContextualKey<? extends MessageContext>>();
    private final Class<C> type;

    protected ContextualKey(@NotNull String key, @NotNull Class<C> type) {
        super(key);
        this.type = type;
        REGISTERED_KEYS.add(this);
    }

    public Class<C> getType() {
        return this.type;
    }

    @NotNull
    public static Set<ContextualKey<? extends MessageContext>> getRegisteredKeys() {
        return Collections.unmodifiableSet(REGISTERED_KEYS);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContextualKey that = (ContextualKey)o;
        return this.type.equals(that.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.type);
    }

    @Override
    public String toString() {
        return "ContextualKey{type=" + this.type + ", super=" + super.toString() + "}";
    }
}

