/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.core.flag.internal;

import java.lang.reflect.Method;
import me.monoto.cmd.core.BaseCommand;
import me.monoto.cmd.core.exceptions.SubCommandRegistrationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlagValidator {
    private FlagValidator() {
        throw new AssertionError((Object)"Util class must not be initialized.");
    }

    public static void validate(@Nullable String flag, @NotNull Method method, @NotNull BaseCommand baseCommand) {
        if (flag == null) {
            return;
        }
        if (flag.length() == 1) {
            char character = flag.charAt(0);
            if (!FlagValidator.isValidFlag(character)) {
                throw new SubCommandRegistrationException("Illegal flag name \"" + character + "\"", method, baseCommand.getClass());
            }
            return;
        }
        for (char character : flag.toCharArray()) {
            if (FlagValidator.isValidChar(character)) continue;
            throw new SubCommandRegistrationException("The flag \"" + flag + "\" contains an illegal character \"" + character + "\"", method, baseCommand.getClass());
        }
    }

    private static boolean isValidFlag(char c) {
        return FlagValidator.isValidChar(c) || c == '?' || c == '@';
    }

    private static boolean isValidChar(char c) {
        return Character.isJavaIdentifierPart(c);
    }
}

