/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.core.flag.internal;

import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class FlagScanner {
    private final List<String> tokens;
    private int pointer = -1;
    private String current = null;

    public FlagScanner(@NotNull List<String> tokens) {
        this.tokens = tokens;
    }

    @NotNull
    public String peek() {
        return this.current;
    }

    public boolean hasNext() {
        return this.pointer < this.tokens.size() - 1;
    }

    @NotNull
    public String next() {
        if (this.pointer < this.tokens.size()) {
            ++this.pointer;
        }
        this.setToken(this.tokens.get(this.pointer));
        return this.peek();
    }

    public void previous() {
        if (this.pointer > 0) {
            --this.pointer;
        }
        this.setToken(this.tokens.get(this.pointer));
    }

    private void setToken(@NotNull String token) {
        this.current = token;
    }
}

