/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.core.argument.named;

import java.util.List;
import java.util.Set;
import me.monoto.cmd.core.argument.named.ArgumentBuilder;
import me.monoto.cmd.core.argument.named.ListArgumentBuilder;
import me.monoto.cmd.core.suggestion.SuggestionKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Argument {
    public static ArgumentBuilder forString() {
        return new ArgumentBuilder(String.class);
    }

    public static ArgumentBuilder forInt() {
        return new ArgumentBuilder(Integer.TYPE);
    }

    public static ArgumentBuilder forFloat() {
        return new ArgumentBuilder(Float.TYPE);
    }

    public static ArgumentBuilder forDouble() {
        return new ArgumentBuilder(Double.TYPE);
    }

    public static ArgumentBuilder forBoolean() {
        return new ArgumentBuilder(Boolean.TYPE);
    }

    public static ArgumentBuilder forType(@NotNull Class<?> type) {
        return new ArgumentBuilder(type);
    }

    public static ListArgumentBuilder listOf(@NotNull Class<?> type) {
        return new ListArgumentBuilder(List.class, type);
    }

    public static ListArgumentBuilder setOf(@NotNull Class<?> type) {
        return new ListArgumentBuilder(Set.class, type);
    }

    @NotNull
    public Class<?> getType();

    @NotNull
    public String getName();

    @NotNull
    public String getDescription();

    @Nullable
    public SuggestionKey getSuggestion();
}

