/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.core.argument.named;

import me.monoto.cmd.core.argument.named.Argument;
import me.monoto.cmd.core.argument.named.SimpleArgument;
import me.monoto.cmd.core.exceptions.CommandRegistrationException;
import me.monoto.cmd.core.suggestion.SuggestionKey;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractArgumentBuilder<T extends AbstractArgumentBuilder<T>> {
    private final Class<?> type;
    private String name;
    private String description = "Description!";
    private SuggestionKey suggestionKey;

    public AbstractArgumentBuilder(@NotNull Class<?> type) {
        this.type = type;
    }

    @NotNull
    @Contract(value="_ -> this")
    public T name(@NotNull String name) {
        this.name = name;
        return (T)this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public T description(@NotNull String description) {
        this.description = description;
        return (T)this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public T suggestion(@NotNull SuggestionKey suggestionKey) {
        this.suggestionKey = suggestionKey;
        return (T)this;
    }

    @NotNull
    @Contract(value=" -> new")
    public Argument build() {
        return new SimpleArgument(this);
    }

    @NotNull
    Class<?> getType() {
        return this.type;
    }

    @NotNull
    String getName() {
        if (this.name == null || this.name.isEmpty()) {
            throw new CommandRegistrationException("Argument is missing a name!");
        }
        return this.name;
    }

    @NotNull
    String getDescription() {
        return this.description;
    }

    @Nullable
    SuggestionKey getSuggestionKey() {
        return this.suggestionKey;
    }
}

