/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.core.argument;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.monoto.cmd.core.argument.InternalArgument;
import me.monoto.cmd.core.argument.LimitlessInternalArgument;
import me.monoto.cmd.core.argument.StringInternalArgument;
import me.monoto.cmd.core.argument.named.Arguments;
import me.monoto.cmd.core.argument.named.NamedArgumentParser;
import me.monoto.cmd.core.argument.named.NamedArgumentResult;
import me.monoto.cmd.core.suggestion.EmptySuggestion;
import me.monoto.cmd.core.suggestion.SuggestionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NamedInternalArgument<S>
extends LimitlessInternalArgument<S> {
    private final Map<String, InternalArgument<S, ?>> arguments;

    public NamedInternalArgument(@NotNull String name, @NotNull String description, @NotNull Map<String, InternalArgument<S, ?>> arguments, int position, boolean isOptional) {
        super(name, description, Arguments.class, new EmptySuggestion(), position, isOptional);
        this.arguments = arguments;
    }

    @Override
    @NotNull
    public Object resolve(@NotNull S sender, @NotNull List<String> value) {
        Map<String, String> parsedArgs = NamedArgumentParser.parse(String.join((CharSequence)" ", value));
        HashMap<String, Object> mapped = new HashMap<String, Object>(parsedArgs.size());
        for (Map.Entry<String, String> entry : parsedArgs.entrySet()) {
            String key = entry.getKey();
            InternalArgument<S, ?> argument = this.arguments.get(key);
            if (argument == null) continue;
            Object resolved = this.resolveArgument(sender, argument, entry.getValue());
            mapped.put(key, resolved);
        }
        return new NamedArgumentResult(mapped);
    }

    @Override
    public List<String> suggestions(@NotNull S sender, @NotNull List<String> trimmed, @NotNull SuggestionContext context) {
        String argName;
        Map<String, String> parsedArgs = NamedArgumentParser.parse(String.join((CharSequence)" ", trimmed));
        String current = trimmed.get(trimmed.size() - 1);
        List<String> notUsed = this.arguments.keySet().stream().filter(it -> parsedArgs.get(it) == null).filter(it -> it.startsWith(current)).map(it -> it + ":").collect(Collectors.toList());
        if (notUsed.size() > 1) {
            return notUsed;
        }
        if (notUsed.size() == 1) {
            argName = notUsed.get(0).replace(":", "");
        } else {
            ArrayList<String> parsed = new ArrayList<String>(parsedArgs.keySet());
            if (parsed.size() == 0) {
                return Collections.emptyList();
            }
            argName = (String)parsed.get(parsed.size() - 1);
        }
        InternalArgument<S, ?> argument = this.arguments.get(argName);
        if (argument != null) {
            String raw = argName + ":";
            List<String> parsed = argument.suggestions(sender, Collections.singletonList(!current.contains(raw) ? "" : current.replace(raw, "")), context);
            if (parsed.isEmpty()) {
                return Collections.singletonList(raw);
            }
            return parsed.stream().map(it -> argName + ":" + it).collect(Collectors.toList());
        }
        return notUsed;
    }

    @Nullable
    private Object resolveArgument(@NotNull S sender, @NotNull InternalArgument<S, ?> argument, @NotNull String value) {
        if (argument instanceof StringInternalArgument) {
            return ((StringInternalArgument)argument).resolve(sender, value);
        }
        return null;
    }

    @Override
    @NotNull
    public String toString() {
        return "NamedInternalArgument{arguments=" + this.arguments + ", super=" + super.toString() + "}";
    }
}

