/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.core.argument;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.monoto.cmd.core.argument.LimitlessInternalArgument;
import me.monoto.cmd.core.flag.Flags;
import me.monoto.cmd.core.flag.internal.FlagGroup;
import me.monoto.cmd.core.flag.internal.FlagOptions;
import me.monoto.cmd.core.flag.internal.FlagParser;
import me.monoto.cmd.core.suggestion.EmptySuggestion;
import me.monoto.cmd.core.suggestion.SuggestionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlagInternalArgument<S>
extends LimitlessInternalArgument<S> {
    private final FlagGroup<S> flagGroup;
    private final FlagParser<S> flagParser;

    public FlagInternalArgument(@NotNull String name, @NotNull String description, @NotNull FlagGroup<S> flagGroup, int position, boolean isOptional) {
        super(name, description, Flags.class, new EmptySuggestion(), position, isOptional);
        this.flagGroup = flagGroup;
        this.flagParser = new FlagParser<S>(flagGroup);
    }

    @Override
    @NotNull
    public Object resolve(@NotNull S sender, @NotNull List<String> value) {
        return this.flagParser.parse(sender, value.size() == 1 ? Arrays.asList(value.get(0).split(" ")) : value);
    }

    @Override
    public List<String> suggestions(@NotNull S sender, @NotNull List<String> trimmed, @NotNull SuggestionContext context) {
        String flag;
        int size = trimmed.size();
        String current = trimmed.get(size - 1);
        List<String> flags = this.flagGroup.getAllFlags();
        ArrayList<Map.Entry<FlagOptions<S>, String>> parsed = new ArrayList<Map.Entry<FlagOptions<S>, String>>(this.flagParser.parseFlags(trimmed).entrySet());
        ArrayList<String> used = new ArrayList<String>();
        for (Map.Entry entry : parsed) {
            FlagOptions options = (FlagOptions)entry.getKey();
            flag = options.getFlag();
            String longFlag = options.getLongFlag();
            if (flag != null) {
                used.add("-" + flag);
            }
            if (longFlag == null) continue;
            used.add("--" + longFlag);
        }
        if (!parsed.isEmpty()) {
            Map.Entry last = (Map.Entry)parsed.get(parsed.size() - 1);
            FlagOptions flagOptions = (FlagOptions)last.getKey();
            if (!current.contains("=")) {
                if (size > 1 && flagOptions.hasArgument() && flags.contains(trimmed.get(size - 2))) {
                    return flagOptions.getArgument().suggestions(sender, Collections.singletonList(current), context);
                }
            } else {
                String arg;
                String[] split = current.split("=");
                if (split.length == 0) {
                    return Collections.emptyList();
                }
                flag = split[0];
                String string = arg = split.length != 2 ? "" : split[1];
                if (flagOptions.hasArgument()) {
                    return flagOptions.getArgument().suggestions(sender, Collections.singletonList(arg), context).stream().map(it -> flag + "=" + it).collect(Collectors.toList());
                }
            }
        }
        return flags.stream().filter(it -> !used.contains(it)).filter(it -> it.toLowerCase().startsWith(current.toLowerCase())).collect(Collectors.toList());
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FlagInternalArgument that = (FlagInternalArgument)o;
        return this.flagGroup.equals(that.flagGroup);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.flagGroup);
    }

    @Override
    @NotNull
    public String toString() {
        return "FlagArgument{flagGroup=" + this.flagGroup + ", super=" + super.toString() + "}";
    }
}

