/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.core.argument;

import java.lang.ref.WeakReference;
import java.util.Objects;
import me.monoto.cmd.core.argument.StringInternalArgument;
import me.monoto.cmd.core.suggestion.Suggestion;
import me.monoto.cmd.core.util.EnumUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnumInternalArgument<S>
extends StringInternalArgument<S> {
    private final Class<? extends Enum<?>> enumType;

    public EnumInternalArgument(@NotNull String name, @NotNull String description, @NotNull Class<? extends Enum<?>> type, @NotNull Suggestion<S> suggestion, int position, boolean optional) {
        super(name, description, type, suggestion, position, optional);
        this.enumType = type;
        EnumUtils.populateCache(type);
    }

    public Class<? extends Enum<?>> getEnumType() {
        return this.enumType;
    }

    @Override
    @Nullable
    public Object resolve(@NotNull S sender, @NotNull String value) {
        WeakReference<Enum<?>> reference = EnumUtils.getEnumConstants(this.enumType).get(value.toUpperCase());
        if (reference == null) {
            return null;
        }
        return reference.get();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnumInternalArgument that = (EnumInternalArgument)o;
        return this.enumType.equals(that.enumType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.enumType);
    }

    @Override
    @NotNull
    public String toString() {
        return "EnumArgument{enumType=" + this.enumType + ", super=" + super.toString() + "}";
    }
}

