/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.core.argument;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.HashMap;
import java.util.Map;
import me.monoto.cmd.core.argument.ArgumentResolver;
import me.monoto.cmd.core.registry.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArgumentRegistry<S>
implements Registry {
    private final Map<Class<?>, ArgumentResolver<S>> arguments = new HashMap();

    public ArgumentRegistry() {
        this.register(Short.TYPE, (sender, arg) -> Ints.tryParse((String)arg));
        this.register(Short.class, (sender, arg) -> Ints.tryParse((String)arg));
        this.register(Integer.TYPE, (sender, arg) -> Ints.tryParse((String)arg));
        this.register(Integer.class, (sender, arg) -> Ints.tryParse((String)arg));
        this.register(Long.TYPE, (sender, arg) -> Longs.tryParse((String)arg));
        this.register(Long.class, (sender, arg) -> Longs.tryParse((String)arg));
        this.register(Float.TYPE, (sender, arg) -> Floats.tryParse((String)arg));
        this.register(Float.class, (sender, arg) -> Floats.tryParse((String)arg));
        this.register(Double.TYPE, (sender, arg) -> Doubles.tryParse((String)arg));
        this.register(Double.class, (sender, arg) -> Doubles.tryParse((String)arg));
        this.register(Boolean.TYPE, (sender, arg) -> Boolean.valueOf(arg));
        this.register(Boolean.class, (sender, arg) -> Boolean.valueOf(arg));
        this.register(String.class, (sender, arg) -> arg);
    }

    public void register(@NotNull Class<?> clazz, ArgumentResolver<S> argument) {
        this.arguments.put(clazz, argument);
    }

    @Nullable
    public ArgumentResolver<S> getResolver(@NotNull Class<?> clazz) {
        return this.arguments.get(clazz);
    }
}

