/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.core.argument;

import java.util.List;
import java.util.Objects;
import me.monoto.cmd.core.argument.InternalArgument;
import me.monoto.cmd.core.suggestion.Suggestion;
import me.monoto.cmd.core.suggestion.SuggestionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInternalArgument<S, T>
implements InternalArgument<S, T> {
    private final String name;
    private final String description;
    private final Class<?> type;
    private final int position;
    private final boolean optional;
    private final Suggestion<S> suggestion;

    public AbstractInternalArgument(@NotNull String name, @NotNull String description, @NotNull Class<?> type, @NotNull Suggestion<S> suggestion, int position, boolean optional) {
        this.name = name;
        this.description = description;
        this.type = type;
        this.suggestion = suggestion;
        this.position = position;
        this.optional = optional;
    }

    @Override
    public List<String> suggestions(@NotNull S sender, @NotNull List<String> trimmed, @NotNull SuggestionContext context) {
        return this.suggestion.getSuggestions(sender, trimmed.get(0), context);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    protected Suggestion<S> getSuggestion() {
        return this.suggestion;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractInternalArgument internalArgument = (AbstractInternalArgument)o;
        return this.optional == internalArgument.optional && this.name.equals(internalArgument.name) && this.type.equals(internalArgument.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.optional);
    }

    public String toString() {
        return "AbstractInternalArgument{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", type=" + this.type + ", position=" + this.position + ", optional=" + this.optional + ", suggestion=" + this.suggestion + '}';
    }
}

