/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.core;

import java.util.Arrays;
import java.util.List;
import me.monoto.cmd.core.BaseCommand;
import me.monoto.cmd.core.argument.ArgumentResolver;
import me.monoto.cmd.core.argument.named.Argument;
import me.monoto.cmd.core.argument.named.ArgumentKey;
import me.monoto.cmd.core.message.ContextualKey;
import me.monoto.cmd.core.message.MessageResolver;
import me.monoto.cmd.core.message.context.MessageContext;
import me.monoto.cmd.core.registry.RegistryContainer;
import me.monoto.cmd.core.requirement.RequirementKey;
import me.monoto.cmd.core.requirement.RequirementResolver;
import me.monoto.cmd.core.sender.SenderMapper;
import me.monoto.cmd.core.sender.SenderValidator;
import me.monoto.cmd.core.suggestion.SuggestionKey;
import me.monoto.cmd.core.suggestion.SuggestionResolver;
import org.jetbrains.annotations.NotNull;

public abstract class CommandManager<DS, S> {
    private final SenderMapper<DS, S> senderMapper;
    private final SenderValidator<S> senderValidator;

    public CommandManager(@NotNull SenderMapper<DS, S> senderMapper, @NotNull SenderValidator<S> senderValidator) {
        this.senderMapper = senderMapper;
        this.senderValidator = senderValidator;
    }

    public abstract void registerCommand(@NotNull BaseCommand var1);

    public final void registerCommand(BaseCommand ... baseCommands) {
        for (BaseCommand command : baseCommands) {
            this.registerCommand(command);
        }
    }

    public abstract void unregisterCommand(@NotNull BaseCommand var1);

    public final void unregisterCommands(BaseCommand ... commands) {
        for (BaseCommand command : commands) {
            this.unregisterCommand(command);
        }
    }

    public final void registerArgument(@NotNull Class<?> clazz, @NotNull ArgumentResolver<S> resolver) {
        this.getRegistryContainer().getArgumentRegistry().register(clazz, resolver);
    }

    public void registerSuggestion(@NotNull SuggestionKey key, @NotNull SuggestionResolver<S> suggestionResolver) {
        this.getRegistryContainer().getSuggestionRegistry().register(key, suggestionResolver);
    }

    public void registerSuggestion(@NotNull Class<?> type, @NotNull SuggestionResolver<S> suggestionResolver) {
        this.getRegistryContainer().getSuggestionRegistry().register(type, suggestionResolver);
    }

    public final void registerNamedArguments(@NotNull ArgumentKey key, Argument ... arguments) {
        this.registerNamedArguments(key, Arrays.asList(arguments));
    }

    public final void registerNamedArguments(@NotNull ArgumentKey key, @NotNull @NotNull List<@NotNull Argument> arguments) {
        this.getRegistryContainer().getNamedArgumentRegistry().register(key, arguments);
    }

    public final <C extends MessageContext> void registerMessage(@NotNull ContextualKey<C> key, @NotNull MessageResolver<S, C> resolver) {
        this.getRegistryContainer().getMessageRegistry().register(key, resolver);
    }

    public final void registerRequirement(@NotNull RequirementKey key, @NotNull RequirementResolver<S> resolver) {
        this.getRegistryContainer().getRequirementRegistry().register(key, resolver);
    }

    @NotNull
    protected abstract RegistryContainer<S> getRegistryContainer();

    protected SenderMapper<DS, S> getSenderMapper() {
        return this.senderMapper;
    }

    protected SenderValidator<S> getSenderValidator() {
        return this.senderValidator;
    }
}

