/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.bukkit;

import java.lang.reflect.Method;
import me.monoto.cmd.bukkit.annotation.Permission;
import me.monoto.cmd.core.BaseCommand;
import me.monoto.cmd.core.exceptions.SubCommandRegistrationException;
import me.monoto.cmd.core.processor.AbstractSubCommandProcessor;
import me.monoto.cmd.core.registry.RegistryContainer;
import me.monoto.cmd.core.sender.SenderValidator;
import org.jetbrains.annotations.NotNull;

final class BukkitSubCommandProcessor<S>
extends AbstractSubCommandProcessor<S> {
    private String permission = "";

    public BukkitSubCommandProcessor(@NotNull BaseCommand baseCommand, @NotNull String parentName, @NotNull Method method, @NotNull RegistryContainer<S> registryContainer, @NotNull SenderValidator<S> senderValidator) {
        super(baseCommand, parentName, method, registryContainer, senderValidator);
        if (this.getName() == null) {
            return;
        }
        this.checkPermission(this.getMethod());
    }

    @NotNull
    public String getPermission() {
        return this.permission;
    }

    private void checkPermission(@NotNull Method method) {
        Permission permission = method.getAnnotation(Permission.class);
        if (permission == null) {
            return;
        }
        String annotatedPermission = permission.value();
        if (annotatedPermission.isEmpty()) {
            throw new SubCommandRegistrationException("Permission cannot be empty", method, this.getBaseCommand().getClass());
        }
        this.permission = annotatedPermission;
    }
}

