/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.bukkit;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import me.monoto.cmd.bukkit.message.BukkitMessageKey;
import me.monoto.cmd.core.SubCommand;
import me.monoto.cmd.core.message.MessageRegistry;
import me.monoto.cmd.core.message.context.DefaultMessageContext;
import me.monoto.cmd.core.sender.SenderValidator;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

class BukkitSenderValidator
implements SenderValidator<CommandSender> {
    BukkitSenderValidator() {
    }

    @Override
    @NotNull
    public Set<Class<? extends CommandSender>> getAllowedSenders() {
        return ImmutableSet.of(CommandSender.class, ConsoleCommandSender.class, Player.class);
    }

    @Override
    public boolean validate(@NotNull MessageRegistry<CommandSender> messageRegistry, @NotNull SubCommand<CommandSender> subCommand, @NotNull CommandSender sender) {
        Class<CommandSender> senderClass = subCommand.getSenderType();
        if (Player.class.isAssignableFrom(senderClass) && !(sender instanceof Player)) {
            messageRegistry.sendMessage(BukkitMessageKey.PLAYER_ONLY, sender, new DefaultMessageContext(subCommand.getParentName(), subCommand.getName()));
            return false;
        }
        if (ConsoleCommandSender.class.isAssignableFrom(senderClass) && !(sender instanceof ConsoleCommandSender)) {
            messageRegistry.sendMessage(BukkitMessageKey.CONSOLE_ONLY, sender, new DefaultMessageContext(subCommand.getParentName(), subCommand.getName()));
            return false;
        }
        return true;
    }
}

