/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.bukkit;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import me.monoto.cmd.bukkit.BukkitAsyncExecutionProvider;
import me.monoto.cmd.bukkit.BukkitCommand;
import me.monoto.cmd.bukkit.BukkitCommandProcessor;
import me.monoto.cmd.bukkit.BukkitSenderValidator;
import me.monoto.cmd.bukkit.message.BukkitMessageKey;
import me.monoto.cmd.core.BaseCommand;
import me.monoto.cmd.core.CommandManager;
import me.monoto.cmd.core.exceptions.CommandRegistrationException;
import me.monoto.cmd.core.execution.ExecutionProvider;
import me.monoto.cmd.core.execution.SyncExecutionProvider;
import me.monoto.cmd.core.message.MessageKey;
import me.monoto.cmd.core.registry.RegistryContainer;
import me.monoto.cmd.core.sender.SenderMapper;
import me.monoto.cmd.core.sender.SenderValidator;
import me.monoto.cmd.core.suggestion.SuggestionContext;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class BukkitCommandManager<S>
extends CommandManager<CommandSender, S> {
    private final Plugin plugin;
    private final RegistryContainer<S> registryContainer = new RegistryContainer();
    private final Map<String, BukkitCommand<S>> commands = new HashMap<String, BukkitCommand<S>>();
    private final ExecutionProvider syncExecutionProvider = new SyncExecutionProvider();
    private final ExecutionProvider asyncExecutionProvider;
    private final CommandMap commandMap;
    private final Map<String, Command> bukkitCommands;

    private BukkitCommandManager(@NotNull Plugin plugin, @NotNull SenderMapper<CommandSender, S> senderMapper, @NotNull SenderValidator<S> senderValidator) {
        super(senderMapper, senderValidator);
        this.plugin = plugin;
        this.asyncExecutionProvider = new BukkitAsyncExecutionProvider(plugin);
        this.commandMap = this.getCommandMap();
        this.bukkitCommands = this.getBukkitCommands(this.commandMap);
    }

    @NotNull
    @Contract(value="_ -> new")
    public static BukkitCommandManager<CommandSender> create(@NotNull Plugin plugin) {
        BukkitCommandManager<CommandSender> commandManager = new BukkitCommandManager<CommandSender>(plugin, SenderMapper.defaultMapper(), new BukkitSenderValidator());
        BukkitCommandManager.setUpDefaults(commandManager);
        return commandManager;
    }

    @NotNull
    @Contract(value="_, _, _ -> new")
    public static <S> BukkitCommandManager<S> create(@NotNull Plugin plugin, @NotNull SenderMapper<CommandSender, S> senderMapper, @NotNull SenderValidator<S> senderValidator) {
        return new BukkitCommandManager<S>(plugin, senderMapper, senderValidator);
    }

    @Override
    public void registerCommand(@NotNull BaseCommand baseCommand) {
        BukkitCommandProcessor<S> processor = new BukkitCommandProcessor<S>(baseCommand, this.registryContainer, this.getSenderMapper(), this.getSenderValidator(), this.syncExecutionProvider, this.asyncExecutionProvider);
        BukkitCommand command = this.commands.computeIfAbsent(processor.getName(), ignored -> this.createAndRegisterCommand(processor.getName(), processor));
        command.addSubCommands(processor.getSubCommands(), processor.getSubCommandsAlias());
        processor.getAlias().forEach(it -> {
            BukkitCommand aliasCommand = this.commands.computeIfAbsent((String)it, ignored -> this.createAndRegisterCommand((String)it, processor));
            aliasCommand.addSubCommands(processor.getSubCommands(), processor.getSubCommandsAlias());
        });
    }

    @Override
    public void unregisterCommand(@NotNull BaseCommand command) {
    }

    @Override
    @NotNull
    protected RegistryContainer<S> getRegistryContainer() {
        return this.registryContainer;
    }

    private BukkitCommand<S> createAndRegisterCommand(@NotNull String name, @NotNull BukkitCommandProcessor<S> processor) {
        Command oldCommand = this.commandMap.getCommand(name);
        if (oldCommand instanceof PluginIdentifiableCommand && ((PluginIdentifiableCommand)oldCommand).getPlugin() == this.plugin) {
            this.bukkitCommands.remove(name);
            oldCommand.unregister(this.commandMap);
        }
        BukkitCommand<S> newCommand = new BukkitCommand<S>(name, processor);
        this.commandMap.register(this.plugin.getName(), newCommand);
        return newCommand;
    }

    private static void setUpDefaults(@NotNull BukkitCommandManager<CommandSender> manager) {
        manager.registerMessage(MessageKey.UNKNOWN_COMMAND, (sender, context) -> sender.sendMessage("Unknown command: `" + context.getCommand() + "`."));
        manager.registerMessage(MessageKey.TOO_MANY_ARGUMENTS, (sender, context) -> sender.sendMessage("Invalid usage."));
        manager.registerMessage(MessageKey.NOT_ENOUGH_ARGUMENTS, (sender, context) -> sender.sendMessage("Invalid usage."));
        manager.registerMessage(MessageKey.INVALID_ARGUMENT, (sender, context) -> sender.sendMessage("Invalid argument `" + context.getTypedArgument() + "` for type `" + context.getArgumentType().getSimpleName() + "`."));
        manager.registerMessage(BukkitMessageKey.NO_PERMISSION, (sender, context) -> sender.sendMessage("You do not have permission to perform this command. Permission needed: `" + context.getPermission() + "`."));
        manager.registerMessage(BukkitMessageKey.PLAYER_ONLY, (sender, context) -> sender.sendMessage("This command can only be used by players."));
        manager.registerMessage(BukkitMessageKey.CONSOLE_ONLY, (sender, context) -> sender.sendMessage("This command can only be used by the console."));
        manager.registerArgument(Material.class, (sender, arg) -> Material.matchMaterial((String)arg));
        manager.registerArgument(Player.class, (sender, arg) -> Bukkit.getPlayer((String)arg));
        manager.registerArgument(World.class, (sender, arg) -> Bukkit.getWorld((String)arg));
        manager.registerSuggestion(Player.class, (S sender, SuggestionContext context) -> Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList()));
    }

    @NotNull
    private CommandMap getCommandMap() {
        try {
            Server server = Bukkit.getServer();
            Method getCommandMap = server.getClass().getDeclaredMethod("getCommandMap", new Class[0]);
            getCommandMap.setAccessible(true);
            return (CommandMap)getCommandMap.invoke((Object)server, new Object[0]);
        }
        catch (Exception ignored) {
            throw new CommandRegistrationException("Unable get Command Map. Commands will not be registered!");
        }
    }

    @NotNull
    private Map<String, Command> getBukkitCommands(@NotNull CommandMap commandMap) {
        try {
            Field bukkitCommands = SimpleCommandMap.class.getDeclaredField("knownCommands");
            bukkitCommands.setAccessible(true);
            return (Map)bukkitCommands.get(commandMap);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new CommandRegistrationException("Unable get Bukkit commands. Commands might not be registered correctly!");
        }
    }
}

