/*
 * Decompiled with CFR 0.152.
 */
package me.monoto.cmd.bukkit;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.monoto.cmd.bukkit.BukkitCommandProcessor;
import me.monoto.cmd.bukkit.BukkitSubCommand;
import me.monoto.cmd.bukkit.message.BukkitMessageKey;
import me.monoto.cmd.bukkit.message.NoPermissionMessageContext;
import me.monoto.cmd.core.message.MessageKey;
import me.monoto.cmd.core.message.MessageRegistry;
import me.monoto.cmd.core.message.context.DefaultMessageContext;
import me.monoto.cmd.core.registry.RegistryContainer;
import me.monoto.cmd.core.sender.SenderMapper;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BukkitCommand<S>
extends Command
implements me.monoto.cmd.core.Command<S, BukkitSubCommand<S>> {
    private final MessageRegistry<S> messageRegistry;
    private final SenderMapper<CommandSender, S> senderMapper;
    private final Map<String, BukkitSubCommand<S>> subCommands = new HashMap<String, BukkitSubCommand<S>>();
    private final Map<String, BukkitSubCommand<S>> subCommandAliases = new HashMap<String, BukkitSubCommand<S>>();

    public BukkitCommand(@NotNull String name, @NotNull BukkitCommandProcessor<S> processor) {
        super(name);
        this.description = processor.getDescription();
        RegistryContainer registryContainer = processor.getRegistryContainer();
        this.messageRegistry = registryContainer.getMessageRegistry();
        this.senderMapper = processor.getSenderMapper();
    }

    @Override
    public void addSubCommands(@NotNull Map<String, BukkitSubCommand<S>> subCommands, @NotNull Map<String, BukkitSubCommand<S>> subCommandAliases) {
        this.subCommands.putAll(subCommands);
        this.subCommandAliases.putAll(subCommandAliases);
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        BukkitSubCommand<S> subCommand = this.getDefaultSubCommand();
        String subCommandName = "";
        if (args.length > 0) {
            subCommandName = args[0].toLowerCase();
        }
        if (subCommand == null || this.subCommandExists(subCommandName)) {
            subCommand = this.getSubCommand(subCommandName);
        }
        S mappedSender = this.senderMapper.map(sender);
        if (subCommand == null || args.length > 0 && subCommand.isDefault() && !subCommand.hasArguments()) {
            this.messageRegistry.sendMessage(MessageKey.UNKNOWN_COMMAND, mappedSender, new DefaultMessageContext(this.getName(), subCommandName));
            return true;
        }
        String permission = subCommand.getPermission();
        if (!permission.isEmpty() && !sender.hasPermission(permission)) {
            this.messageRegistry.sendMessage(BukkitMessageKey.NO_PERMISSION, mappedSender, new NoPermissionMessageContext(this.getName(), subCommand.getName(), permission));
            return true;
        }
        List<String> commandArgs = Arrays.asList(!subCommand.isDefault() ? Arrays.copyOfRange(args, 1, args.length) : args);
        subCommand.execute(mappedSender, commandArgs);
        return true;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
        if (args.length == 0) {
            return Collections.emptyList();
        }
        BukkitSubCommand<S> subCommand = this.getDefaultSubCommand();
        String arg = args[0].toLowerCase();
        if (!(args.length != 1 || subCommand != null && subCommand.hasArguments())) {
            return this.subCommands.entrySet().stream().filter(it -> !((BukkitSubCommand)it.getValue()).isDefault()).filter(it -> ((String)it.getKey()).startsWith(arg)).filter(it -> {
                String permission = ((BukkitSubCommand)it.getValue()).getPermission();
                if (permission.isEmpty()) {
                    return true;
                }
                return sender.hasPermission(permission);
            }).map(Map.Entry::getKey).collect(Collectors.toList());
        }
        if (this.subCommandExists(arg)) {
            subCommand = this.getSubCommand(arg);
        }
        if (subCommand == null) {
            return Collections.emptyList();
        }
        String permission = subCommand.getPermission();
        if (!permission.isEmpty() && !sender.hasPermission(permission)) {
            return Collections.emptyList();
        }
        S mappedSender = this.senderMapper.map(sender);
        List<String> commandArgs = Arrays.asList(args);
        return subCommand.getSuggestions(mappedSender, !subCommand.isDefault() ? commandArgs.subList(1, commandArgs.size()) : commandArgs);
    }

    @Nullable
    private BukkitSubCommand<S> getDefaultSubCommand() {
        return this.subCommands.get("TH_DEFAULT");
    }

    @Nullable
    private BukkitSubCommand<S> getSubCommand(@NotNull String key) {
        BukkitSubCommand<S> subCommand = this.subCommands.get(key);
        if (subCommand != null) {
            return subCommand;
        }
        return this.subCommandAliases.get(key);
    }

    private boolean subCommandExists(@NotNull String key) {
        return this.subCommands.containsKey(key) || this.subCommandAliases.containsKey(key);
    }
}

