/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import net.noscape.project.supremetags.SupremeTags;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class Utils {
    private static Pattern p1 = Pattern.compile("\\{#([0-9A-Fa-f]{6})\\}");
    private static Pattern p2 = Pattern.compile("&#([A-Fa-f0-9]){6}");
    private static Pattern p3 = Pattern.compile("#([A-Fa-f0-9]){6}");
    private static Pattern rgbPat = Pattern.compile("(?:#|0x)(?:[a-f0-9]{3}|[a-f0-9]{6})\\b|(?:rgb|hsl)a?\\([^\\)]*\\)");

    public static String format(String message) {
        if (SupremeTags.getInstance().isCMIHex()) {
            Matcher match = p1.matcher(message);
            while (match.find()) {
                Utils.getRGB(message);
            }
            return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        }
        if (SupremeTags.getInstance().isLegacyFormat()) {
            message = message.replace(">>", "").replace("<<", "");
            Matcher matcher = p2.matcher(message);
            while (matcher.find()) {
                ChatColor hexColor = ChatColor.of((String)matcher.group().substring(1));
                String before = message.substring(0, matcher.start());
                String after = message.substring(matcher.end());
                message = before + hexColor + after;
                matcher = p2.matcher(message);
            }
            return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        }
        message = message.replace(">>", "").replace("<<", "");
        Matcher matcher = p3.matcher(message);
        while (matcher.find()) {
            ChatColor hexColor = ChatColor.of((String)matcher.group().substring(1));
            String before = message.substring(0, matcher.start());
            String after = message.substring(matcher.end());
            message = before + hexColor + after;
            matcher = p3.matcher(message);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static String colorizeRGB(String input) {
        Matcher matcher = p1.matcher(input);
        while (matcher.find()) {
            String color = matcher.group(1);
            if (color == null) {
                color = matcher.group(2);
            }
            input = input.replace(matcher.group(), ChatColor.of((String)color) + "");
        }
        return input;
    }

    public static void addPerm(Player player, String permission) {
        SupremeTags.getPermissions().playerAdd(player, permission);
    }

    public static boolean hasAmount(Player player, double cost) {
        return SupremeTags.getEconomy().has((OfflinePlayer)player, cost);
    }

    public static void take(Player player, double cost) {
        SupremeTags.getEconomy().withdrawPlayer((OfflinePlayer)player, cost);
    }

    public static String deformat(String str) {
        return ChatColor.stripColor((String)Utils.format(str));
    }

    public static void msgPlayer(Player player, String ... str) {
        for (String msg : str) {
            player.sendMessage(Utils.format(msg));
        }
    }

    public static void msgPlayer(CommandSender player, String ... str) {
        for (String msg : str) {
            player.sendMessage(Utils.format(msg));
        }
    }

    public static void titlePlayer(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        player.sendTitle(Utils.format(title), Utils.format(subtitle), fadeIn, stay, fadeOut);
    }

    public static void soundPlayer(Player player, Sound sound, float volume, float pitch) {
        player.playSound(player.getLocation(), sound, volume, pitch);
    }

    public static List<String> color(List<String> lore) {
        return lore.stream().map(Utils::format).collect(Collectors.toList());
    }

    public static String getRGB(String msg) {
        String temp = msg;
        try {
            String status = "none";
            String r = "";
            String g = "";
            String b = "";
            Matcher match = rgbPat.matcher(msg);
            while (match.find()) {
                String color = msg.substring(match.start(), match.end());
                block25: for (char character : msg.substring(match.start(), match.end()).toCharArray()) {
                    switch (character) {
                        case '(': {
                            status = "r";
                            continue block25;
                        }
                        case ',': {
                            switch (status) {
                                case "r": {
                                    status = "g";
                                    continue block25;
                                }
                                case "g": {
                                    status = "b";
                                    continue block25;
                                }
                            }
                        }
                        default: {
                            switch (status) {
                                case "r": {
                                    r = r + character;
                                    continue block25;
                                }
                                case "g": {
                                    g = g + character;
                                    continue block25;
                                }
                                case "b": {
                                    b = b + character;
                                    continue block25;
                                }
                            }
                        }
                    }
                }
                b = b.replace(")", "");
                Color col = new Color(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
                temp = temp.replaceFirst("(?:#|0x)(?:[a-f0-9]{3}|[a-f0-9]{6})\\b|(?:rgb|hsl)a?\\([^\\)]*\\)", ChatColor.of((Color)col) + "");
                r = "";
                g = "";
                b = "";
                status = "none";
            }
        }
        catch (Exception e) {
            return msg;
        }
        return temp;
    }

    public static String replacePlaceholders(Player user, String base) {
        return PlaceholderAPI.setPlaceholders((Player)user, (String)base);
    }

    public static ItemStack createSkull(String baseheadtexture64) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        if (baseheadtexture64 == null || baseheadtexture64.isEmpty()) {
            return skull;
        }
        SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
        assert (skullMeta != null);
        skullMeta.setOwningPlayer(null);
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", baseheadtexture64));
        try {
            Field profileField = skullMeta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(skullMeta, profile);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        skull.setItemMeta((ItemMeta)skullMeta);
        return skull;
    }
}

