/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.storage;

import java.io.File;
import java.io.IOException;
import net.noscape.project.supremetags.SupremeTags;
import net.noscape.project.supremetags.handlers.Tag;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlayerConfig {
    public boolean exists(OfflinePlayer player) {
        return new File(SupremeTags.getInstance().getDataFolder(), "data/" + player.getUniqueId() + ".yml").exists();
    }

    public static FileConfiguration get(OfflinePlayer offlinePlayer) {
        File file = new File(SupremeTags.getInstance().getDataFolder(), "data/" + offlinePlayer.getUniqueId() + ".yml");
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public void save(Player player) {
        if (this.exists((OfflinePlayer)player)) {
            File file = new File(SupremeTags.getInstance().getDataFolder(), "data/" + player.getUniqueId() + ".yml");
            YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
            try {
                configuration.save(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void loadPlayer(OfflinePlayer player) {
        if (this.exists(player)) {
            File file = new File(SupremeTags.getInstance().getDataFolder(), "data/" + player.getUniqueId() + ".yml");
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            for (String identifier : config.getConfigurationSection("tags").getKeys(false)) {
                String tag = config.getString("tags." + identifier + ".tag");
                String description = config.getString("tags." + identifier + ".description");
                Tag t = new Tag(identifier, tag, "", "", description, 0.0);
                SupremeTags.getInstance().getPlayerManager().getPlayerTags().put(player.getUniqueId(), t);
            }
        } else {
            this.createFile(player);
        }
    }

    void createFile(OfflinePlayer player) {
        File folder = new File(SupremeTags.getInstance().getDataFolder(), "data");
        File file = new File(SupremeTags.getInstance().getDataFolder(), "data/" + player.getUniqueId() + ".yml");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!file.exists()) {
            YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
            configuration.createSection("tags");
            try {
                configuration.save(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void reset(OfflinePlayer player) {
        File file = new File(SupremeTags.getInstance().getDataFolder(), "data/" + player.getUniqueId() + ".yml");
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        configuration.set("tags", null);
        try {
            configuration.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

