/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.storage;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import net.noscape.project.supremetags.SupremeTags;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class MySQLUserData {
    public boolean exists(Player player) {
        try {
            PreparedStatement statement = SupremeTags.getMysql().getConnection().prepareStatement("SELECT * FROM `users` WHERE (UUID=?)");
            statement.setString(1, player.getUniqueId().toString());
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void createPlayer(Player player) {
        if (this.exists(player)) {
            return;
        }
        String defaultTag = SupremeTags.getInstance().getConfig().getString("settings.default-tag");
        try (PreparedStatement statement = SupremeTags.getMysql().getConnection().prepareStatement("INSERT INTO `users` (Name, UUID, Active) VALUES (?,?,?)");){
            statement.setString(1, player.getName());
            statement.setString(2, player.getUniqueId().toString());
            statement.setString(3, defaultTag);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void setActive(OfflinePlayer player, String identifier) {
        String sql = "UPDATE `users` SET Active=? WHERE (UUID=?)";
        try (PreparedStatement statement = SupremeTags.getMysql().getConnection().prepareStatement(sql);){
            statement.setString(1, identifier);
            statement.setString(2, player.getUniqueId().toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static String getActive(UUID uuid) {
        String value = "";
        String query = "SELECT * FROM `users` WHERE (UUID=?)";
        try (PreparedStatement statement = SupremeTags.getMysql().getConnection().prepareStatement(query);){
            statement.setString(1, uuid.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    value = resultSet.getString("Active");
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return value;
    }
}

