/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.storage;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.noscape.project.supremetags.SupremeTags;
import org.bukkit.Bukkit;

public class Database {
    private final String ConnectionURL;

    public Database(String connectionURL) {
        this.ConnectionURL = connectionURL;
        this.initialiseDatabase();
    }

    public Connection getConnection() {
        Connection connection = null;
        try {
            Class.forName("org.h2.Driver");
            connection = DriverManager.getConnection(SupremeTags.getConnectionURL());
        }
        catch (ClassNotFoundException | SQLException throwables) {
            throwables.printStackTrace();
            Bukkit.getConsoleSender().sendMessage("H2: Something wrong with connecting to h2-sql, contact the developer if you see this.");
        }
        return connection;
    }

    public void initialiseDatabase() {
        String userTable = "CREATE TABLE IF NOT EXISTS `users` (`Name` VARCHAR(100), `UUID` VARCHAR(100) primary key, `Active` VARCHAR(100))";
        String ptTable = "CREATE TABLE IF NOT EXISTS `pttags` (`UUID` VARCHAR(100) primary key, `Name` VARCHAR(100), `Tag` VARCHAR(100))";
        try {
            PreparedStatement preparedStatement = this.getConnection().prepareStatement(userTable);
            preparedStatement.executeUpdate();
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }

    public String getConnectionURL() {
        return this.ConnectionURL;
    }
}

