/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.managers;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import net.noscape.project.supremetags.SupremeTags;
import net.noscape.project.supremetags.handlers.Tag;
import net.noscape.project.supremetags.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TagManager {
    private final Map<String, Tag> tags = new HashMap<String, Tag>();
    private final Map<Integer, String> dataItem = new HashMap<Integer, String>();
    private boolean isCost;
    private String reload = SupremeTags.getInstance().getConfig().getString("messages.reload");
    private String noperm = SupremeTags.getInstance().getConfig().getString("messages.no-permission");
    private String notags = SupremeTags.getInstance().getConfig().getString("messages.no-tags");
    private String commanddisabled = SupremeTags.getInstance().getConfig().getString("messages.tag-command-disabled");
    private String invalidtag = SupremeTags.getInstance().getConfig().getString("messages.invalid-tag");
    private String validtag = SupremeTags.getInstance().getConfig().getString("messages.valid-tag");
    private String invalidcategory = SupremeTags.getInstance().getConfig().getString("messages.invalid-category");

    public TagManager(boolean isCost) {
        this.sort();
        this.isCost = isCost;
    }

    public void createTag(Player player, String identifier, String tag_string, String description, String permission, double cost) {
        if (!this.tags.containsKey(identifier)) {
            String default_category = SupremeTags.getInstance().getConfig().getString("settings.default-category");
            Tag tag = new Tag(identifier, tag_string, default_category, permission, description, cost);
            this.tags.put(identifier, tag);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".tag", (Object)tag_string);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".permission", (Object)permission);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".description", (Object)description);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".category", (Object)default_category);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".display-item", (Object)"NAME_TAG");
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".displayname", (Object)"&7Tag: %tag%");
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".cost", (Object)cost);
            SupremeTags.getInstance().saveConfig();
            SupremeTags.getInstance().reloadConfig();
            Utils.msgPlayer(player, "&8[&6&lTAG&8] &7New tag created &6" + identifier + " &f- " + tag_string);
        } else {
            Utils.msgPlayer(player, this.validtag);
        }
    }

    public void createTag(CommandSender player, String identifier, String tag_string, String description, String permission, double cost) {
        if (!this.tags.containsKey(identifier)) {
            String default_category = SupremeTags.getInstance().getConfig().getString("settings.default-category");
            Tag tag = new Tag(identifier, tag_string, default_category, permission, description, cost);
            this.tags.put(identifier, tag);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".tag", (Object)tag_string);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".permission", (Object)permission);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".description", (Object)description);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".category", (Object)default_category);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".display-item", (Object)"NAME_TAG");
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".displayname", (Object)"&7Tag: %tag%");
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".cost", (Object)cost);
            SupremeTags.getInstance().saveConfig();
            SupremeTags.getInstance().reloadConfig();
            Utils.msgPlayer(player, "&8[&6&lTAG&8] &7New tag created &6" + identifier + " &f- " + tag_string);
        } else {
            Utils.msgPlayer(player, this.validtag);
        }
    }

    public void createTag(String identifier, String tag_string, String description, String permission, double cost) {
        if (!this.tags.containsKey(identifier)) {
            String default_category = SupremeTags.getInstance().getConfig().getString("settings.default-category");
            Tag tag = new Tag(identifier, tag_string, default_category, permission, description, cost);
            this.tags.put(identifier, tag);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".tag", (Object)tag_string);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".permission", (Object)permission);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".description", (Object)description);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".category", (Object)default_category);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".display-item", (Object)"NAME_TAG");
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".displayname", (Object)"&7Tag: %tag%");
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".cost", (Object)cost);
            SupremeTags.getInstance().saveConfig();
            SupremeTags.getInstance().reloadConfig();
        }
    }

    public void createTag(String identifier, String material, String tag_string, String description, String permission, double cost) {
        if (!this.tags.containsKey(identifier)) {
            String default_category = SupremeTags.getInstance().getConfig().getString("settings.default-category");
            Tag tag = new Tag(identifier, tag_string, default_category, permission, description, cost);
            this.tags.put(identifier, tag);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".tag", (Object)tag_string);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".permission", (Object)permission);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".description", (Object)description);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".category", (Object)default_category);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".display-item", (Object)material);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".displayname", (Object)"&7Tag: %tag%");
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".cost", (Object)cost);
            SupremeTags.getInstance().saveConfig();
            SupremeTags.getInstance().reloadConfig();
        }
    }

    public void deleteTag(CommandSender player, String identifier) {
        if (this.tags.containsKey(identifier)) {
            this.tags.remove(identifier);
            try {
                SupremeTags.getInstance().getConfig().set("tags." + identifier, null);
                SupremeTags.getInstance().saveConfig();
                SupremeTags.getInstance().reloadConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Utils.msgPlayer(player, "&8[&6&lTAG&8] &7Tag &6" + identifier + " &7is now deleted!");
        } else {
            Utils.msgPlayer(player, this.invalidtag);
        }
    }

    public void deleteTag(Player player, String identifier) {
        if (this.tags.containsKey(identifier)) {
            this.tags.remove(identifier);
            try {
                SupremeTags.getInstance().getConfig().set("tags." + identifier, null);
                SupremeTags.getInstance().saveConfig();
                SupremeTags.getInstance().reloadConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Utils.msgPlayer(player, "&8[&6&lTAG&8] &7Tag &6" + identifier + " &7is now deleted!");
        } else {
            Utils.msgPlayer(player, this.invalidtag);
        }
    }

    public void loadTags() {
        int count = 0;
        for (String identifier : Objects.requireNonNull(SupremeTags.getInstance().getConfig().getConfigurationSection("tags")).getKeys(false)) {
            String tag = SupremeTags.getInstance().getConfig().getString("tags." + identifier + ".tag");
            String category = SupremeTags.getInstance().getConfig().getString("tags." + identifier + ".category");
            String description = SupremeTags.getInstance().getConfig().getString("tags." + identifier + ".description");
            String permission = SupremeTags.getInstance().getConfig().getString("tags." + identifier + ".permission") != null ? SupremeTags.getInstance().getConfig().getString("tags." + identifier + ".permission") : "none";
            double cost = SupremeTags.getInstance().getConfig().getDouble("tags." + identifier + ".cost");
            Tag t = new Tag(identifier, tag, category, permission, description, cost);
            this.tags.put(identifier, t);
            ++count;
        }
        Bukkit.getConsoleSender().sendMessage("[TAGS] loaded " + count + " tag(s) successfully.");
    }

    public Tag getTag(String tag) {
        Tag t = null;
        for (Tag tg : this.tags.values()) {
            if (!tg.getIdentifier().equalsIgnoreCase(tag)) continue;
            t = tg;
        }
        return t;
    }

    public void unloadTags() {
        if (!this.tags.isEmpty()) {
            this.tags.clear();
        }
    }

    public Map<String, Tag> getTags() {
        return this.tags;
    }

    public Map<Integer, String> getDataItem() {
        return this.dataItem;
    }

    public void setTag(Player player, String identifier, String tag) {
        if (this.tags.containsKey(identifier)) {
            Tag t = this.tags.get(identifier);
            t.setTag(tag);
            try {
                SupremeTags.getInstance().getConfig().set("tags." + identifier + ".tag", (Object)t.getTag());
                SupremeTags.getInstance().saveConfig();
                SupremeTags.getInstance().reloadConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Utils.msgPlayer(player, "&8[&6&lTAG&8] &6" + t.getIdentifier() + "'s tag &7changed to " + t.getTag());
        } else {
            Utils.msgPlayer(player, this.invalidtag);
        }
    }

    public void setCategory(Player player, String identifier, String category) {
        if (this.tags.containsKey(identifier)) {
            Tag t = this.tags.get(identifier);
            t.setCategory(category);
            try {
                SupremeTags.getInstance().getConfig().set("tags." + identifier + ".category", (Object)t.getCategory());
                SupremeTags.getInstance().saveConfig();
                SupremeTags.getInstance().reloadConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Utils.msgPlayer(player, "&8[&6&lTAG&8] &6" + t.getIdentifier() + "'s category &7changed to " + t.getCategory());
        } else {
            Utils.msgPlayer(player, this.invalidcategory);
        }
    }

    public void setTag(CommandSender player, String identifier, String tag) {
        if (this.tags.containsKey(identifier)) {
            Tag t = this.tags.get(identifier);
            t.setTag(tag);
            try {
                SupremeTags.getInstance().getConfig().set("tags." + identifier + ".tag", (Object)t.getTag());
                SupremeTags.getInstance().saveConfig();
                SupremeTags.getInstance().reloadConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Utils.msgPlayer(player, "&8[&6&lTAG&8] &6" + t.getIdentifier() + "'s tag &7changed to " + t.getTag());
        } else {
            Utils.msgPlayer(player, this.invalidtag);
        }
    }

    public void sort() {
        Comparator comparator = Map.Entry.comparingByKey();
        TreeSet sortedSet = new TreeSet(comparator);
        sortedSet.addAll(this.tags.entrySet());
    }

    public boolean isCost() {
        return this.isCost;
    }

    public void setCost(boolean isCost) {
        this.isCost = isCost;
    }

    public void saveTag(Tag tag) {
        SupremeTags.getInstance().getConfig().set("tags." + tag.getIdentifier() + ".tag", (Object)tag.getTag());
        SupremeTags.getInstance().getConfig().set("tags." + tag.getIdentifier() + ".permission", (Object)tag.getPermission());
        SupremeTags.getInstance().getConfig().set("tags." + tag.getIdentifier() + ".description", (Object)tag.getDescription());
        SupremeTags.getInstance().getConfig().set("tags." + tag.getIdentifier() + ".category", (Object)tag.getCategory());
        SupremeTags.getInstance().getConfig().set("tags." + tag.getIdentifier() + ".cost", (Object)tag.getCost());
        SupremeTags.getInstance().saveConfig();
        SupremeTags.getInstance().reloadConfig();
    }
}

