/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.noscape.project.supremetags.SupremeTags;
import net.noscape.project.supremetags.handlers.Tag;
import net.noscape.project.supremetags.storage.PlayerConfig;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlayerManager {
    private final Map<UUID, Tag> playerTags = new HashMap<UUID, Tag>();

    public List<Tag> getPlayerTags(UUID uuid) {
        ArrayList<Tag> tag_list = new ArrayList<Tag>();
        for (Tag t : this.playerTags.values()) {
            if (this.playerTags.get(uuid) == null) break;
            if (this.playerTags.get(uuid) != t) continue;
            tag_list.add(t);
        }
        return tag_list;
    }

    public void load(Player player) {
        this.playerTags.remove(player.getUniqueId());
        if (PlayerConfig.get((OfflinePlayer)player).getConfigurationSection("tags") != null) {
            for (String identifier : PlayerConfig.get((OfflinePlayer)player).getConfigurationSection("tags").getKeys(false)) {
                String tag = PlayerConfig.get((OfflinePlayer)player).getString("tags." + identifier + ".tag");
                String description = PlayerConfig.get((OfflinePlayer)player).getString("tags." + identifier + ".description");
                Tag t = new Tag(identifier, tag, description);
                this.playerTags.put(player.getUniqueId(), t);
            }
        }
    }

    public Map<UUID, Tag> getPlayerTags() {
        return this.playerTags;
    }

    public void delete(Player player, String identifier) {
        PlayerConfig.get((OfflinePlayer)player).set("tags." + identifier, null);
        SupremeTags.getInstance().getPlayerConfig().save(player);
    }

    public void save(Tag tag, Player player) {
        PlayerConfig.get((OfflinePlayer)player).set("tags." + tag.getIdentifier() + ".tag", (Object)tag.getTag());
        PlayerConfig.get((OfflinePlayer)player).set("tags." + tag.getIdentifier() + ".description", (Object)tag.getDescription());
        SupremeTags.getInstance().getPlayerConfig().save(player);
    }
}

