/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.listeners;

import java.util.Map;
import net.noscape.project.supremetags.SupremeTags;
import net.noscape.project.supremetags.handlers.Tag;
import net.noscape.project.supremetags.storage.UserData;
import net.noscape.project.supremetags.utils.Utils;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;

public class PlayerEvents
implements Listener {
    private final Map<String, Tag> tags = SupremeTags.getInstance().getTagManager().getTags();

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        String activeTag;
        Player player = e.getPlayer();
        UserData.createPlayer(player);
        player.getClientViewDistance();
        if (SupremeTags.getInstance().getConfig().getBoolean("settings.forced-tag") && (activeTag = UserData.getActive(player.getUniqueId())).equalsIgnoreCase("None")) {
            String defaultTag = SupremeTags.getInstance().getConfig().getString("settings.default-tag");
            UserData.setActive((OfflinePlayer)player, defaultTag);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChat(AsyncPlayerChatEvent e) {
        Player player = e.getPlayer();
        String format = e.getFormat();
        String activeTag = UserData.getActive(player.getUniqueId());
        String replace = format.replace("{tag}", "").replace("{supremetags_tag}", "").replace("{TAG}", "");
        if (activeTag == null || activeTag.equalsIgnoreCase("None")) {
            e.setFormat(replace);
        } else {
            Tag tag = SupremeTags.getInstance().getTagManager().getTags().get(activeTag);
            if (tag == null) {
                e.setFormat(replace);
            } else {
                String formattedTag = Utils.format(tag.getTag());
                formattedTag = Utils.replacePlaceholders(player, formattedTag);
                e.setFormat(format.replace("{tag}", formattedTag).replace("{supremetags_tag}", formattedTag).replace("{TAG}", formattedTag));
            }
        }
    }

    public Map<String, Tag> getTags() {
        return this.tags;
    }
}

