/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.handlers.menu;

import de.tr7zw.nbtapi.NBTItem;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import net.noscape.project.supremetags.SupremeTags;
import net.noscape.project.supremetags.handlers.Tag;
import net.noscape.project.supremetags.handlers.menu.Menu;
import net.noscape.project.supremetags.handlers.menu.MenuUtil;
import net.noscape.project.supremetags.storage.UserData;
import net.noscape.project.supremetags.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class Paged
extends Menu {
    protected int page = 0;
    protected int maxItems = 35;
    protected int index = 0;
    private final int tagsCount;
    private int currentItemsOnPage = 0;

    public Paged(MenuUtil menuUtil) {
        super(menuUtil);
        Map<String, Tag> tags = SupremeTags.getInstance().getTagManager().getTags();
        ArrayList<Tag> tag = new ArrayList<Tag>(tags.values());
        this.tagsCount = tag.size();
    }

    public void applyEditorLayout() {
        String back = SupremeTags.getInstance().getConfig().getString("gui.strings.back-item");
        String close = SupremeTags.getInstance().getConfig().getString("gui.strings.close-item");
        String next = SupremeTags.getInstance().getConfig().getString("gui.strings.next-item");
        this.inventory.setItem(48, this.makeItem(Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.back-next-material")).toUpperCase()), back, new String[0]));
        this.inventory.setItem(49, this.makeItem(Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.close-menu-material")).toUpperCase()), close, new String[0]));
        if (this.getCurrentItemsOnPage() == 36 && this.tagsCount > 36) {
            this.inventory.setItem(50, this.makeItem(Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.back-next-material")).toUpperCase()), next, new String[0]));
        }
        this.inventory.setItem(36, this.GLASS);
        this.inventory.setItem(37, this.GLASS);
        this.inventory.setItem(38, this.GLASS);
        this.inventory.setItem(39, this.GLASS);
        this.inventory.setItem(40, this.GLASS);
        this.inventory.setItem(41, this.GLASS);
        this.inventory.setItem(42, this.GLASS);
        this.inventory.setItem(43, this.GLASS);
        this.inventory.setItem(44, this.GLASS);
    }

    public void applyLayout() {
        String back = SupremeTags.getInstance().getConfig().getString("gui.strings.back-item");
        String close = SupremeTags.getInstance().getConfig().getString("gui.strings.close-item");
        String next = SupremeTags.getInstance().getConfig().getString("gui.strings.next-item");
        String refresh = SupremeTags.getInstance().getConfig().getString("gui.strings.refresh-item");
        String reset = SupremeTags.getInstance().getConfig().getString("gui.strings.reset-item");
        String active = SupremeTags.getInstance().getConfig().getString("gui.strings.active-item");
        if (SupremeTags.getInstance().getConfig().getBoolean("gui.items.back-item")) {
            this.inventory.setItem(48, this.makeItem(Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.back-next-material")).toUpperCase()), back, new String[0]));
        }
        if (SupremeTags.getInstance().getConfig().getBoolean("gui.items.close-item")) {
            this.inventory.setItem(49, this.makeItem(Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.close-menu-material")).toUpperCase()), close, new String[0]));
        }
        if (this.getCurrentItemsOnPage() >= 36 && SupremeTags.getInstance().getConfig().getBoolean("gui.items.next-item")) {
            this.inventory.setItem(50, this.makeItem(Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.back-next-material")).toUpperCase()), next, new String[0]));
        }
        if (!SupremeTags.getInstance().getConfig().getBoolean("settings.forced-tag") || SupremeTags.getInstance().getConfig().getBoolean("gui.items.reset-item")) {
            this.inventory.setItem(46, this.makeItem(Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.reset-tag-material")).toUpperCase()), reset, new String[0]));
        }
        if (SupremeTags.getInstance().getConfig().getBoolean("gui.items.refresh-item")) {
            this.inventory.setItem(45, this.makeItem(Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.refresh-material")).toUpperCase()), refresh, new String[0]));
        }
        if (SupremeTags.getInstance().getConfig().getBoolean("gui.items.active-item")) {
            active = active.replaceAll("%identifier%", UserData.getActive(this.menuUtil.getOwner().getUniqueId()));
            active = SupremeTags.getInstance().getTagManager().getTag(UserData.getActive(this.menuUtil.getOwner().getUniqueId())) != null ? active.replaceAll("%tag%", SupremeTags.getInstance().getTagManager().getTag(UserData.getActive(this.menuUtil.getOwner().getUniqueId())).getTag()) : active.replaceAll("%tag%", "");
            if (Bukkit.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
                active = Utils.replacePlaceholders(this.menuUtil.getOwner(), active);
            }
            this.inventory.setItem(52, this.makeItem(Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.active-tag-material")).toUpperCase()), Utils.format(active), new String[0]));
        }
        if (SupremeTags.getInstance().getConfig().getBoolean("gui.items.glass-item")) {
            this.inventory.setItem(36, this.GLASS);
            this.inventory.setItem(37, this.GLASS);
            this.inventory.setItem(38, this.GLASS);
            this.inventory.setItem(39, this.GLASS);
            this.inventory.setItem(40, this.GLASS);
            this.inventory.setItem(41, this.GLASS);
            this.inventory.setItem(42, this.GLASS);
            this.inventory.setItem(43, this.GLASS);
            this.inventory.setItem(44, this.GLASS);
        }
    }

    public void applyPTLayout() {
        String back = SupremeTags.getInstance().getConfig().getString("gui.strings.back-item");
        String close = SupremeTags.getInstance().getConfig().getString("gui.strings.close-item");
        String next = SupremeTags.getInstance().getConfig().getString("gui.strings.next-item");
        String refresh = SupremeTags.getInstance().getConfig().getString("gui.strings.refresh-item");
        String reset = SupremeTags.getInstance().getConfig().getString("gui.strings.reset-item");
        String active = SupremeTags.getInstance().getConfig().getString("gui.strings.active-item");
        this.inventory.setItem(48, this.makeItem(Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.back-next-material")).toUpperCase()), back, new String[0]));
        if (SupremeTags.getInstance().getConfig().getBoolean("gui.items.close-item")) {
            this.inventory.setItem(49, this.makeItem(Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.close-menu-material")).toUpperCase()), close, new String[0]));
        }
        if (this.currentItemsOnPage > 36) {
            this.inventory.setItem(50, this.makeItem(Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.back-next-material")).toUpperCase()), next, new String[0]));
        }
        if (!SupremeTags.getInstance().getConfig().getBoolean("settings.forced-tag") || SupremeTags.getInstance().getConfig().getBoolean("gui.items.reset-item")) {
            this.inventory.setItem(46, this.makeItem(Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.reset-tag-material")).toUpperCase()), reset, new String[0]));
        }
        this.inventory.setItem(53, this.makeItem(Material.BOOK, ChatColor.AQUA + "Create a Tag", new String[0]));
        if (SupremeTags.getInstance().getConfig().getBoolean("gui.items.refresh-item")) {
            this.inventory.setItem(45, this.makeItem(Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.refresh-material")).toUpperCase()), refresh, new String[0]));
        }
        if (SupremeTags.getInstance().getConfig().getBoolean("gui.items.active-item")) {
            active = active.replaceAll("%identifier%", UserData.getActive(this.menuUtil.getOwner().getUniqueId()));
            active = active.replaceAll("%tag%", SupremeTags.getInstance().getTagManager().getTag(UserData.getActive(this.menuUtil.getOwner().getUniqueId())).getTag());
            active = Utils.replacePlaceholders(this.menuUtil.getOwner(), active);
            this.inventory.setItem(52, this.makeItem(Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.active-tag-material")).toUpperCase()), Utils.format(active), new String[0]));
        }
        if (SupremeTags.getInstance().getConfig().getBoolean("gui.items.glass-item")) {
            this.inventory.setItem(36, this.GLASS);
            this.inventory.setItem(37, this.GLASS);
            this.inventory.setItem(38, this.GLASS);
            this.inventory.setItem(39, this.GLASS);
            this.inventory.setItem(40, this.GLASS);
            this.inventory.setItem(41, this.GLASS);
            this.inventory.setItem(42, this.GLASS);
            this.inventory.setItem(43, this.GLASS);
            this.inventory.setItem(44, this.GLASS);
        }
    }

    protected int getPage() {
        return this.page + 1;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void getTagItemsCost() {
        Map<String, Tag> tags = SupremeTags.getInstance().getTagManager().getTags();
        ArrayList<Tag> tag = new ArrayList<Tag>(tags.values());
        if (!tag.isEmpty()) {
            int maxItemsPerPage = 36;
            int startIndex = this.page * maxItemsPerPage;
            int endIndex = Math.min(startIndex + maxItemsPerPage, tag.size());
            tag.sort((tag1, tag2) -> {
                boolean hasPermission1 = this.menuUtil.getOwner().hasPermission(tag1.getPermission());
                boolean hasPermission2 = this.menuUtil.getOwner().hasPermission(tag2.getPermission());
                if (hasPermission1 && !hasPermission2) {
                    return -1;
                }
                if (!hasPermission1 && hasPermission2) {
                    return 1;
                }
                return tag1.getIdentifier().compareTo(tag2.getIdentifier());
            });
            this.currentItemsOnPage = 0;
            for (int i = startIndex; i < endIndex; ++i) {
                ArrayList lore;
                NBTItem nbt;
                ArrayList lore2;
                NBTItem nbt2;
                ItemMeta tagMeta;
                ArrayList lore3;
                NBTItem nbt3;
                ItemMeta tagMeta2;
                ItemStack tagItem;
                Tag t = tag.get(i);
                if (t == null) continue;
                String permission = SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".permission");
                double cost = SupremeTags.getInstance().getConfig().getDouble("tags." + t.getIdentifier() + ".cost");
                String displayname = SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".displayname") != null ? Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".displayname")).replace("%tag%", t.getTag()) : Utils.format("&7Tag: " + t.getTag());
                if (SupremeTags.getInstance().isPlaceholderAPI()) {
                    displayname = Utils.replacePlaceholders(this.menuUtil.getOwner(), displayname);
                }
                String material = SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".display-item") != null ? SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".display-item") : "NAME_TAG";
                assert (permission != null);
                if (this.menuUtil.getOwner().hasPermission("supremetags.tag.*") || this.menuUtil.getOwner().hasPermission(permission) && !permission.equalsIgnoreCase("none") || t.getCost() == 0.0) {
                    if (material.contains("hdb-")) {
                        HeadDatabaseAPI api = new HeadDatabaseAPI();
                        int id = Integer.parseInt(material.replaceAll("hdb-", ""));
                        tagItem = api.getItemHead(String.valueOf(id));
                        tagMeta2 = tagItem.getItemMeta();
                        assert (tagMeta2 != null);
                        nbt3 = new NBTItem(tagItem);
                        nbt3.setString("identifier", t.getIdentifier());
                        tagMeta2.setDisplayName(Utils.format(displayname));
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt3.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore3 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.unlocked-lore");
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t.getCost())));
                        tagMeta2.setLore(Utils.color(lore3));
                        nbt3.getItem().setItemMeta(tagMeta2);
                        nbt3.setString("identifier", t.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt3.getItem()});
                    } else if (material.contains("basehead-")) {
                        String id = material.replaceAll("basehead-", "");
                        ItemStack tagItem2 = Utils.createSkull(id);
                        tagMeta = tagItem2.getItemMeta();
                        assert (tagMeta != null);
                        nbt2 = new NBTItem(tagItem2);
                        nbt2.setString("identifier", t.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt2.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta.setDisplayName(Utils.format(displayname));
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore2 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.unlocked-lore");
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t.getCost())));
                        tagMeta.setLore(Utils.color(lore2));
                        nbt2.getItem().setItemMeta(tagMeta);
                        nbt2.setString("identifier", t.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt2.getItem()});
                    } else {
                        ItemStack tagItem3 = new ItemStack(Material.valueOf((String)material.toUpperCase()), 1);
                        ItemMeta tagMeta3 = tagItem3.getItemMeta();
                        assert (tagMeta3 != null);
                        nbt = new NBTItem(tagItem3);
                        nbt.setString("identifier", t.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta3.setDisplayName(Utils.format(displayname));
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.unlocked-lore");
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t.getCost())));
                        tagMeta3.setLore(Utils.color(lore));
                        nbt.getItem().setItemMeta(tagMeta3);
                        nbt.setString("identifier", t.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt.getItem()});
                    }
                } else if (!this.menuUtil.getOwner().hasPermission("supremetags.tag.*") && !this.menuUtil.getOwner().hasPermission(permission) && permission.equalsIgnoreCase("none")) {
                    if (material.contains("hdb-")) {
                        int id = Integer.parseInt(material.replaceAll("hdb-", ""));
                        HeadDatabaseAPI api = new HeadDatabaseAPI();
                        tagItem = api.getItemHead(String.valueOf(id));
                        tagMeta2 = tagItem.getItemMeta();
                        assert (tagMeta2 != null);
                        nbt3 = new NBTItem(tagItem);
                        nbt3.setString("identifier", t.getIdentifier());
                        tagMeta2.setDisplayName(Utils.format(displayname));
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt3.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        lore3 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t.getCost())));
                        tagMeta2.setLore(Utils.color(lore3));
                        nbt3.getItem().setItemMeta(tagMeta2);
                        nbt3.setString("identifier", t.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt3.getItem()});
                    } else if (material.contains("basehead-")) {
                        String id = material.replaceAll("basehead-", "");
                        ItemStack tagItem4 = Utils.createSkull(id);
                        tagMeta = tagItem4.getItemMeta();
                        assert (tagMeta != null);
                        nbt2 = new NBTItem(tagItem4);
                        nbt2.setString("identifier", t.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt2.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta.setDisplayName(Utils.format(displayname));
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore2 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t.getCost())));
                        tagMeta.setLore(Utils.color(lore2));
                        nbt2.getItem().setItemMeta(tagMeta);
                        nbt2.setString("identifier", t.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt2.getItem()});
                    } else {
                        ItemStack tagItem5 = new ItemStack(Material.valueOf((String)material.toUpperCase()), 1);
                        ItemMeta tagMeta4 = tagItem5.getItemMeta();
                        assert (tagMeta4 != null);
                        nbt = new NBTItem(tagItem5);
                        nbt.setString("identifier", t.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta4.setDisplayName(Utils.format(displayname));
                        tagMeta4.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta4.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta4.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta4.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t.getCost())));
                        tagMeta4.setLore(Utils.color(lore));
                        nbt.getItem().setItemMeta(tagMeta4);
                        nbt.setString("identifier", t.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt.getItem()});
                    }
                } else if (!this.menuUtil.getOwner().hasPermission("supremetags.tag.*") && !this.menuUtil.getOwner().hasPermission(permission)) {
                    if (material.contains("hdb-")) {
                        int id = Integer.parseInt(material.replaceAll("hdb-", ""));
                        HeadDatabaseAPI api = new HeadDatabaseAPI();
                        tagItem = api.getItemHead(String.valueOf(id));
                        tagMeta2 = tagItem.getItemMeta();
                        assert (tagMeta2 != null);
                        nbt3 = new NBTItem(tagItem);
                        nbt3.setString("identifier", t.getIdentifier());
                        tagMeta2.setDisplayName(Utils.format(displayname));
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt3.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        if (!SupremeTags.getInstance().getConfig().getBoolean("settings.locked-view")) {
                            lore3 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t.getCost())));
                        } else {
                            lore3 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-permission");
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t.getCost())));
                        }
                        tagMeta2.setLore(Utils.color(lore3));
                        nbt3.getItem().setItemMeta(tagMeta2);
                        nbt3.setString("identifier", t.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt3.getItem()});
                    } else if (material.contains("basehead-")) {
                        String id = material.replaceAll("basehead-", "");
                        ItemStack tagItem6 = Utils.createSkull(id);
                        tagMeta = tagItem6.getItemMeta();
                        assert (tagMeta != null);
                        nbt2 = new NBTItem(tagItem6);
                        nbt2.setString("identifier", t.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt2.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta.setDisplayName(Utils.format(displayname));
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        if (!SupremeTags.getInstance().getConfig().getBoolean("settings.locked-view")) {
                            lore2 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t.getCost())));
                        } else {
                            lore2 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-permission");
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t.getCost())));
                        }
                        tagMeta.setLore(Utils.color(lore2));
                        nbt2.getItem().setItemMeta(tagMeta);
                        nbt2.setString("identifier", t.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt2.getItem()});
                    } else {
                        ItemStack tagItem7 = new ItemStack(Material.valueOf((String)material.toUpperCase()), 1);
                        ItemMeta tagMeta5 = tagItem7.getItemMeta();
                        assert (tagMeta5 != null);
                        nbt = new NBTItem(tagItem7);
                        nbt.setString("identifier", t.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta5.setDisplayName(Utils.format(displayname));
                        tagMeta5.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta5.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta5.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta5.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        if (!SupremeTags.getInstance().getConfig().getBoolean("settings.locked-view")) {
                            lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t.getCost())));
                        } else {
                            lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-permission");
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t.getCost())));
                        }
                        tagMeta5.setLore(Utils.color(lore));
                        nbt.getItem().setItemMeta(tagMeta5);
                        nbt.setString("identifier", t.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt.getItem()});
                    }
                }
                ++this.currentItemsOnPage;
            }
        }
    }

    public void getTagItems() {
        Map<String, Tag> tags = SupremeTags.getInstance().getTagManager().getTags();
        ArrayList<Tag> tag = new ArrayList<Tag>(tags.values());
        if (!tag.isEmpty()) {
            int maxItemsPerPage = 36;
            int startIndex = this.page * maxItemsPerPage;
            int endIndex = Math.min(startIndex + maxItemsPerPage, tag.size());
            tag.sort((tag1, tag2) -> {
                boolean hasPermission1 = this.menuUtil.getOwner().hasPermission(tag1.getPermission());
                boolean hasPermission2 = this.menuUtil.getOwner().hasPermission(tag2.getPermission());
                if (hasPermission1 && !hasPermission2) {
                    return -1;
                }
                if (!hasPermission1 && hasPermission2) {
                    return 1;
                }
                return tag1.getIdentifier().compareTo(tag2.getIdentifier());
            });
            this.currentItemsOnPage = 0;
            for (int i = startIndex; i < endIndex; ++i) {
                ArrayList lore;
                NBTItem nbt;
                ItemMeta tagMeta;
                ArrayList lore2;
                NBTItem nbt2;
                ItemMeta tagMeta2;
                ItemStack tagItem;
                ArrayList lore3;
                NBTItem nbt3;
                ItemMeta tagMeta3;
                ItemStack tagItem2;
                HeadDatabaseAPI api;
                Tag t = tag.get(i);
                if (t == null) continue;
                String permission = SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".permission");
                String displayname = SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".displayname") != null ? Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".displayname")).replace("%tag%", t.getTag()) : Utils.format("&7Tag: " + t.getTag());
                if (SupremeTags.getInstance().isPlaceholderAPI()) {
                    displayname = Utils.replacePlaceholders(this.menuUtil.getOwner(), displayname);
                }
                String material = SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".display-item") != null ? SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".display-item") : "NAME_TAG";
                assert (permission != null);
                if (this.menuUtil.getOwner().hasPermission("supremetags.tag.*") || this.menuUtil.getOwner().hasPermission(permission) && !permission.equalsIgnoreCase("none")) {
                    if (material.contains("hdb-")) {
                        int id = Integer.parseInt(material.replaceAll("hdb-", ""));
                        api = new HeadDatabaseAPI();
                        tagItem2 = api.getItemHead(String.valueOf(id));
                        tagMeta3 = tagItem2.getItemMeta();
                        assert (tagMeta3 != null);
                        nbt3 = new NBTItem(tagItem2);
                        nbt3.setString("identifier", t.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt3.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta3.setDisplayName(Utils.format(displayname));
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore3 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.lore");
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                        tagMeta3.setLore(Utils.color(lore3));
                        nbt3.getItem().setItemMeta(tagMeta3);
                        nbt3.setString("identifier", t.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt3.getItem()});
                    } else if (material.contains("basehead-")) {
                        String id = material.replaceAll("basehead-", "");
                        tagItem = Utils.createSkull(id);
                        tagMeta2 = tagItem.getItemMeta();
                        assert (tagMeta2 != null);
                        nbt2 = new NBTItem(tagItem);
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt2.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        nbt2.setString("identifier", t.getIdentifier());
                        tagMeta2.setDisplayName(Utils.format(displayname));
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore2 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.lore");
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                        tagMeta2.setLore(Utils.color(lore2));
                        nbt2.getItem().setItemMeta(tagMeta2);
                        nbt2.setString("identifier", t.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt2.getItem()});
                    } else {
                        ItemStack tagItem3 = new ItemStack(Material.valueOf((String)material.toUpperCase()), 1);
                        tagMeta = tagItem3.getItemMeta();
                        assert (tagMeta != null);
                        nbt = new NBTItem(tagItem3);
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        nbt.setString("identifier", t.getIdentifier());
                        tagMeta.setDisplayName(Utils.format(displayname));
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.lore");
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                        tagMeta.setLore(Utils.color(lore));
                        nbt.getItem().setItemMeta(tagMeta);
                        nbt.setString("identifier", t.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt.getItem()});
                    }
                } else if (this.menuUtil.getOwner().hasPermission("supremetags.tag.*") && !this.menuUtil.getOwner().hasPermission(permission) && permission.equalsIgnoreCase("none")) {
                    if (material.contains("hdb-")) {
                        int id = Integer.parseInt(material.replaceAll("hdb-", ""));
                        api = new HeadDatabaseAPI();
                        tagItem2 = api.getItemHead(String.valueOf(id));
                        tagMeta3 = tagItem2.getItemMeta();
                        assert (tagMeta3 != null);
                        nbt3 = new NBTItem(tagItem2);
                        nbt3.setString("identifier", t.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt3.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta3.setDisplayName(Utils.format(displayname));
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore3 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.lore");
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                        tagMeta3.setLore(Utils.color(lore3));
                        nbt3.getItem().setItemMeta(tagMeta3);
                        nbt3.setString("identifier", t.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt3.getItem()});
                    } else if (material.contains("basehead-")) {
                        String id = material.replaceAll("basehead-", "");
                        tagItem = Utils.createSkull(id);
                        tagMeta2 = tagItem.getItemMeta();
                        assert (tagMeta2 != null);
                        nbt2 = new NBTItem(tagItem);
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt2.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        nbt2.setString("identifier", t.getIdentifier());
                        tagMeta2.setDisplayName(Utils.format(displayname));
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        lore2 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.lore");
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                        tagMeta2.setLore(Utils.color(lore2));
                        nbt2.getItem().setItemMeta(tagMeta2);
                        nbt2.setString("identifier", t.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt2.getItem()});
                    } else {
                        ItemStack tagItem4 = new ItemStack(Material.valueOf((String)material.toUpperCase()), 1);
                        tagMeta = tagItem4.getItemMeta();
                        assert (tagMeta != null);
                        nbt = new NBTItem(tagItem4);
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        nbt.setString("identifier", t.getIdentifier());
                        tagMeta.setDisplayName(Utils.format(displayname));
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.lore");
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                        tagMeta.setLore(Utils.color(lore));
                        nbt.getItem().setItemMeta(tagMeta);
                        nbt.setString("identifier", t.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt.getItem()});
                    }
                } else if (!this.menuUtil.getOwner().hasPermission("supremetags.tag.*") && !this.menuUtil.getOwner().hasPermission(permission)) {
                    if (material.contains("hdb-")) {
                        int id = Integer.parseInt(material.replaceAll("hdb-", ""));
                        api = new HeadDatabaseAPI();
                        tagItem2 = api.getItemHead(String.valueOf(id));
                        tagMeta3 = tagItem2.getItemMeta();
                        assert (tagMeta3 != null);
                        nbt3 = new NBTItem(tagItem2);
                        nbt3.setString("identifier", t.getIdentifier());
                        tagMeta3.setDisplayName(Utils.format(displayname));
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt3.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        if (!SupremeTags.getInstance().getConfig().getBoolean("settings.locked-view")) {
                            lore3 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t.getCost())));
                        } else {
                            lore3 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-permission");
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t.getCost())));
                        }
                        tagMeta3.setLore(Utils.color(lore3));
                        nbt3.getItem().setItemMeta(tagMeta3);
                        nbt3.setString("identifier", t.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt3.getItem()});
                    } else if (material.contains("basehead-")) {
                        String id = material.replaceAll("basehead-", "");
                        tagItem = Utils.createSkull(id);
                        tagMeta2 = tagItem.getItemMeta();
                        assert (tagMeta2 != null);
                        nbt2 = new NBTItem(tagItem);
                        nbt2.setString("identifier", t.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt2.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta2.setDisplayName(Utils.format(displayname));
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        if (!SupremeTags.getInstance().getConfig().getBoolean("settings.locked-view")) {
                            lore2 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t.getCost())));
                        } else {
                            lore2 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-permission");
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t.getCost())));
                        }
                        tagMeta2.setLore(Utils.color(lore2));
                        nbt2.getItem().setItemMeta(tagMeta2);
                        nbt2.setString("identifier", t.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt2.getItem()});
                    } else {
                        ItemStack tagItem5 = new ItemStack(Material.valueOf((String)material.toUpperCase()), 1);
                        tagMeta = tagItem5.getItemMeta();
                        assert (tagMeta != null);
                        nbt = new NBTItem(tagItem5);
                        nbt.setString("identifier", t.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta.setDisplayName(Utils.format(displayname));
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        if (!SupremeTags.getInstance().getConfig().getBoolean("settings.locked-view")) {
                            lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t.getCost())));
                        } else {
                            lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-permission");
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t.getCost())));
                        }
                        tagMeta.setLore(Utils.color(lore));
                        nbt.getItem().setItemMeta(tagMeta);
                        nbt.setString("identifier", t.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt.getItem()});
                    }
                }
                ++this.currentItemsOnPage;
            }
        }
    }

    public void getTagItemsCostCategory() {
        Map<String, Tag> tags = SupremeTags.getInstance().getTagManager().getTags();
        ArrayList tag = tags.values().stream().filter(t -> t.getCategory().equalsIgnoreCase(this.menuUtil.getCategory())).collect(Collectors.toCollection(ArrayList::new));
        if (!tag.isEmpty()) {
            int maxItemsPerPage = 36;
            int startIndex = this.page * maxItemsPerPage;
            int endIndex = Math.min(startIndex + maxItemsPerPage, tag.size());
            tag.sort((tag1, tag2) -> {
                boolean hasPermission1 = this.menuUtil.getOwner().hasPermission(tag1.getPermission());
                boolean hasPermission2 = this.menuUtil.getOwner().hasPermission(tag2.getPermission());
                if (hasPermission1 && !hasPermission2) {
                    return -1;
                }
                if (!hasPermission1 && hasPermission2) {
                    return 1;
                }
                return tag1.getIdentifier().compareTo(tag2.getIdentifier());
            });
            this.currentItemsOnPage = 0;
            for (int i = startIndex; i < endIndex; ++i) {
                ArrayList lore;
                NBTItem nbt;
                ArrayList lore2;
                NBTItem nbt2;
                ItemMeta tagMeta;
                ArrayList lore3;
                NBTItem nbt3;
                ItemMeta tagMeta2;
                ItemStack tagItem;
                Tag t2 = (Tag)tag.get(i);
                if (t2 == null) continue;
                String permission = SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".permission");
                String displayname = SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".displayname") != null ? Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".displayname")).replace("%tag%", t2.getTag()) : Utils.format("&7Tag: " + t2.getTag());
                if (SupremeTags.getInstance().isPlaceholderAPI()) {
                    displayname = Utils.replacePlaceholders(this.menuUtil.getOwner(), displayname);
                }
                String material = SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".display-item") != null ? SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".display-item") : "NAME_TAG";
                assert (permission != null);
                if (this.menuUtil.getOwner().hasPermission("supremetags.tag.*") || this.menuUtil.getOwner().hasPermission(permission) && !permission.equalsIgnoreCase("none") || t2.getCost() == 0.0) {
                    if (material.contains("hdb-")) {
                        HeadDatabaseAPI api = new HeadDatabaseAPI();
                        int id = Integer.parseInt(material.replaceAll("hdb-", ""));
                        tagItem = api.getItemHead(String.valueOf(id));
                        tagMeta2 = tagItem.getItemMeta();
                        assert (tagMeta2 != null);
                        nbt3 = new NBTItem(tagItem);
                        nbt3.setString("identifier", t2.getIdentifier());
                        tagMeta2.setDisplayName(Utils.format(displayname));
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt3.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore3 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.unlocked-lore");
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        tagMeta2.setLore(Utils.color(lore3));
                        nbt3.getItem().setItemMeta(tagMeta2);
                        nbt3.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt3.getItem()});
                    } else if (material.contains("basehead-")) {
                        String id = material.replaceAll("basehead-", "");
                        ItemStack tagItem2 = Utils.createSkull(id);
                        tagMeta = tagItem2.getItemMeta();
                        assert (tagMeta != null);
                        nbt2 = new NBTItem(tagItem2);
                        nbt2.setString("identifier", t2.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt2.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta.setDisplayName(Utils.format(displayname));
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore2 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.unlocked-lore");
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        tagMeta.setLore(Utils.color(lore2));
                        nbt2.getItem().setItemMeta(tagMeta);
                        nbt2.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt2.getItem()});
                    } else {
                        ItemStack tagItem3 = new ItemStack(Material.valueOf((String)material.toUpperCase()), 1);
                        ItemMeta tagMeta3 = tagItem3.getItemMeta();
                        assert (tagMeta3 != null);
                        nbt = new NBTItem(tagItem3);
                        nbt.setString("identifier", t2.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta3.setDisplayName(Utils.format(displayname));
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.unlocked-lore");
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        tagMeta3.setLore(Utils.color(lore));
                        nbt.getItem().setItemMeta(tagMeta3);
                        nbt.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt.getItem()});
                    }
                } else if (!this.menuUtil.getOwner().hasPermission("supremetags.tag.*") && !this.menuUtil.getOwner().hasPermission(permission) && permission.equalsIgnoreCase("none")) {
                    if (material.contains("hdb-")) {
                        int id = Integer.parseInt(material.replaceAll("hdb-", ""));
                        HeadDatabaseAPI api = new HeadDatabaseAPI();
                        tagItem = api.getItemHead(String.valueOf(id));
                        tagMeta2 = tagItem.getItemMeta();
                        assert (tagMeta2 != null);
                        nbt3 = new NBTItem(tagItem);
                        nbt3.setString("identifier", t2.getIdentifier());
                        tagMeta2.setDisplayName(Utils.format(displayname));
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt3.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        lore3 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        tagMeta2.setLore(Utils.color(lore3));
                        nbt3.getItem().setItemMeta(tagMeta2);
                        nbt3.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt3.getItem()});
                    } else if (material.contains("basehead-")) {
                        String id = material.replaceAll("basehead-", "");
                        ItemStack tagItem4 = Utils.createSkull(id);
                        tagMeta = tagItem4.getItemMeta();
                        assert (tagMeta != null);
                        nbt2 = new NBTItem(tagItem4);
                        nbt2.setString("identifier", t2.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt2.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta.setDisplayName(Utils.format(displayname));
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore2 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        tagMeta.setLore(Utils.color(lore2));
                        nbt2.getItem().setItemMeta(tagMeta);
                        nbt2.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt2.getItem()});
                    } else {
                        ItemStack tagItem5 = new ItemStack(Material.valueOf((String)material.toUpperCase()), 1);
                        ItemMeta tagMeta4 = tagItem5.getItemMeta();
                        assert (tagMeta4 != null);
                        nbt = new NBTItem(tagItem5);
                        nbt.setString("identifier", t2.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta4.setDisplayName(Utils.format(displayname));
                        tagMeta4.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta4.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta4.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta4.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        tagMeta4.setLore(Utils.color(lore));
                        nbt.getItem().setItemMeta(tagMeta4);
                        nbt.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt.getItem()});
                    }
                } else if (!this.menuUtil.getOwner().hasPermission("supremetags.tag.*") && !this.menuUtil.getOwner().hasPermission(permission)) {
                    if (material.contains("hdb-")) {
                        int id = Integer.parseInt(material.replaceAll("hdb-", ""));
                        HeadDatabaseAPI api = new HeadDatabaseAPI();
                        tagItem = api.getItemHead(String.valueOf(id));
                        tagMeta2 = tagItem.getItemMeta();
                        assert (tagMeta2 != null);
                        nbt3 = new NBTItem(tagItem);
                        nbt3.setString("identifier", t2.getIdentifier());
                        tagMeta2.setDisplayName(Utils.format(displayname));
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt3.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        lore3 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        tagMeta2.setLore(Utils.color(lore3));
                        nbt3.getItem().setItemMeta(tagMeta2);
                        nbt3.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt3.getItem()});
                    } else if (material.contains("basehead-")) {
                        String id = material.replaceAll("basehead-", "");
                        ItemStack tagItem6 = Utils.createSkull(id);
                        tagMeta = tagItem6.getItemMeta();
                        assert (tagMeta != null);
                        nbt2 = new NBTItem(tagItem6);
                        nbt2.setString("identifier", t2.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt2.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta.setDisplayName(Utils.format(displayname));
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore2 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        tagMeta.setLore(Utils.color(lore2));
                        nbt2.getItem().setItemMeta(tagMeta);
                        nbt2.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt2.getItem()});
                    } else {
                        ItemStack tagItem7 = new ItemStack(Material.valueOf((String)material.toUpperCase()), 1);
                        ItemMeta tagMeta5 = tagItem7.getItemMeta();
                        assert (tagMeta5 != null);
                        nbt = new NBTItem(tagItem7);
                        nbt.setString("identifier", t2.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta5.setDisplayName(Utils.format(displayname));
                        tagMeta5.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta5.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta5.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta5.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        tagMeta5.setLore(Utils.color(lore));
                        nbt.getItem().setItemMeta(tagMeta5);
                        nbt.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt.getItem()});
                    }
                } else if (!this.menuUtil.getOwner().hasPermission("supremetags.tag.*") && !this.menuUtil.getOwner().hasPermission(permission)) {
                    if (material.contains("hdb-")) {
                        int id = Integer.parseInt(material.replaceAll("hdb-", ""));
                        HeadDatabaseAPI api = new HeadDatabaseAPI();
                        tagItem = api.getItemHead(String.valueOf(id));
                        tagMeta2 = tagItem.getItemMeta();
                        assert (tagMeta2 != null);
                        nbt3 = new NBTItem(tagItem);
                        nbt3.setString("identifier", t2.getIdentifier());
                        tagMeta2.setDisplayName(Utils.format(displayname));
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt3.getItem().addEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        if (!SupremeTags.getInstance().getConfig().getBoolean("settings.locked-view")) {
                            lore3 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        } else {
                            lore3 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-permission");
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        }
                        tagMeta2.setLore(Utils.color(lore3));
                        nbt3.getItem().setItemMeta(tagMeta2);
                        nbt3.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt3.getItem()});
                    } else if (material.contains("basehead-")) {
                        String id = material.replaceAll("basehead-", "");
                        ItemStack tagItem8 = Utils.createSkull(id);
                        tagMeta = tagItem8.getItemMeta();
                        assert (tagMeta != null);
                        nbt2 = new NBTItem(tagItem8);
                        nbt2.setString("identifier", t2.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt2.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta.setDisplayName(Utils.format(displayname));
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        if (!SupremeTags.getInstance().getConfig().getBoolean("settings.locked-view")) {
                            lore2 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        } else {
                            lore2 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-permission");
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        }
                        tagMeta.setLore(Utils.color(lore2));
                        nbt2.getItem().setItemMeta(tagMeta);
                        nbt2.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt2.getItem()});
                    } else {
                        ItemStack tagItem9 = new ItemStack(Material.valueOf((String)material.toUpperCase()), 1);
                        ItemMeta tagMeta6 = tagItem9.getItemMeta();
                        assert (tagMeta6 != null);
                        nbt = new NBTItem(tagItem9);
                        nbt.setString("identifier", t2.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta6.setDisplayName(Utils.format(displayname));
                        tagMeta6.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta6.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta6.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta6.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        if (!SupremeTags.getInstance().getConfig().getBoolean("settings.locked-view")) {
                            lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        } else {
                            lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-permission");
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        }
                        tagMeta6.setLore(Utils.color(lore));
                        nbt.getItem().setItemMeta(tagMeta6);
                        nbt.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt.getItem()});
                    }
                }
                ++this.currentItemsOnPage;
            }
        }
    }

    public void getTagItemsCategory() {
        Map<String, Tag> tags = SupremeTags.getInstance().getTagManager().getTags();
        ArrayList tag = tags.values().stream().filter(t -> t.getCategory().equalsIgnoreCase(this.menuUtil.getCategory())).collect(Collectors.toCollection(ArrayList::new));
        if (!tag.isEmpty()) {
            int maxItemsPerPage = 36;
            int startIndex = this.page * maxItemsPerPage;
            int endIndex = Math.min(startIndex + maxItemsPerPage, tag.size());
            tag.sort((tag1, tag2) -> {
                boolean hasPermission1 = this.menuUtil.getOwner().hasPermission(tag1.getPermission());
                boolean hasPermission2 = this.menuUtil.getOwner().hasPermission(tag2.getPermission());
                if (hasPermission1 && !hasPermission2) {
                    return -1;
                }
                if (!hasPermission1 && hasPermission2) {
                    return 1;
                }
                return tag1.getIdentifier().compareTo(tag2.getIdentifier());
            });
            this.currentItemsOnPage = 0;
            for (int i = startIndex; i < endIndex; ++i) {
                ArrayList lore;
                NBTItem nbt;
                ItemMeta tagMeta;
                ArrayList lore2;
                NBTItem nbt2;
                ItemMeta tagMeta2;
                ItemStack tagItem;
                ArrayList lore3;
                NBTItem nbt3;
                ItemMeta tagMeta3;
                ItemStack tagItem2;
                HeadDatabaseAPI api;
                Tag t2 = (Tag)tag.get(i);
                if (t2 == null) continue;
                String permission = SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".permission");
                String displayname = SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".displayname") != null ? Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".displayname")).replace("%tag%", t2.getTag()) : Utils.format("&7Tag: " + t2.getTag());
                if (SupremeTags.getInstance().isPlaceholderAPI()) {
                    displayname = Utils.replacePlaceholders(this.menuUtil.getOwner(), displayname);
                }
                String material = SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".display-item") != null ? SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".display-item") : "NAME_TAG";
                assert (permission != null);
                if (this.menuUtil.getOwner().hasPermission("supremetags.tag.*") || this.menuUtil.getOwner().hasPermission(permission) && !permission.equalsIgnoreCase("none")) {
                    if (material.contains("hdb-")) {
                        int id = Integer.parseInt(material.replaceAll("hdb-", ""));
                        api = new HeadDatabaseAPI();
                        tagItem2 = api.getItemHead(String.valueOf(id));
                        tagMeta3 = tagItem2.getItemMeta();
                        assert (tagMeta3 != null);
                        nbt3 = new NBTItem(tagItem2);
                        nbt3.setString("identifier", t2.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt3.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta3.setDisplayName(Utils.format(displayname));
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore3 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.lore");
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                        tagMeta3.setLore(Utils.color(lore3));
                        nbt3.getItem().setItemMeta(tagMeta3);
                        nbt3.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt3.getItem()});
                    } else if (material.contains("basehead-")) {
                        String id = material.replaceAll("basehead-", "");
                        tagItem = Utils.createSkull(id);
                        tagMeta2 = tagItem.getItemMeta();
                        assert (tagMeta2 != null);
                        nbt2 = new NBTItem(tagItem);
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt2.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        nbt2.setString("identifier", t2.getIdentifier());
                        tagMeta2.setDisplayName(Utils.format(displayname));
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore2 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.lore");
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                        lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                        tagMeta2.setLore(Utils.color(lore2));
                        nbt2.getItem().setItemMeta(tagMeta2);
                        nbt2.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt2.getItem()});
                    } else {
                        ItemStack tagItem3 = new ItemStack(Material.valueOf((String)material.toUpperCase()), 1);
                        tagMeta = tagItem3.getItemMeta();
                        assert (tagMeta != null);
                        nbt = new NBTItem(tagItem3);
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        nbt.setString("identifier", t2.getIdentifier());
                        tagMeta.setDisplayName(Utils.format(displayname));
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.lore");
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                        tagMeta.setLore(Utils.color(lore));
                        nbt.getItem().setItemMeta(tagMeta);
                        nbt.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt.getItem()});
                    }
                } else if (this.menuUtil.getOwner().hasPermission("supremetags.tag.*") && !this.menuUtil.getOwner().hasPermission(permission) && permission.equalsIgnoreCase("none")) {
                    if (material.contains("hdb-")) {
                        int id = Integer.parseInt(material.replaceAll("hdb-", ""));
                        api = new HeadDatabaseAPI();
                        tagItem2 = api.getItemHead(String.valueOf(id));
                        tagMeta3 = tagItem2.getItemMeta();
                        assert (tagMeta3 != null);
                        nbt3 = new NBTItem(tagItem2);
                        nbt3.setString("identifier", t2.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt3.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta3.setDisplayName(Utils.format(displayname));
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta3.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        lore3 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.lore");
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                        lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                        tagMeta3.setLore(Utils.color(lore3));
                        nbt3.getItem().setItemMeta(tagMeta3);
                        nbt3.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt3.getItem()});
                    } else if (material.contains("basehead-")) {
                        String id = material.replaceAll("basehead-", "");
                        tagItem = Utils.createSkull(id);
                        tagMeta2 = tagItem.getItemMeta();
                        assert (tagMeta2 != null);
                        nbt2 = new NBTItem(tagItem);
                        nbt2.setString("identifier", t2.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt2.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta2.setDisplayName(Utils.format(displayname));
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        if (!SupremeTags.getInstance().getConfig().getBoolean("settings.locked-view")) {
                            lore2 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        } else {
                            lore2 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-permission");
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        }
                        tagMeta2.setLore(Utils.color(lore2));
                        nbt2.getItem().setItemMeta(tagMeta2);
                        nbt2.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt2.getItem()});
                    } else {
                        ItemStack tagItem4 = new ItemStack(Material.valueOf((String)material.toUpperCase()), 1);
                        tagMeta = tagItem4.getItemMeta();
                        assert (tagMeta != null);
                        nbt = new NBTItem(tagItem4);
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        nbt.setString("identifier", t2.getIdentifier());
                        tagMeta.setDisplayName(Utils.format(displayname));
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.lore");
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                        lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                        tagMeta.setLore(Utils.color(lore));
                        nbt.getItem().setItemMeta(tagMeta);
                        nbt.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt.getItem()});
                    }
                } else if (!this.menuUtil.getOwner().hasPermission("supremetags.tag.*") && !this.menuUtil.getOwner().hasPermission(permission)) {
                    if (material.contains("hdb-")) {
                        int id = Integer.parseInt(material.replaceAll("hdb-", ""));
                        api = new HeadDatabaseAPI();
                        tagItem2 = api.getItemHead(String.valueOf(id));
                        tagMeta3 = tagItem2.getItemMeta();
                        assert (tagMeta3 != null);
                        nbt3 = new NBTItem(tagItem2);
                        nbt3.setString("identifier", t2.getIdentifier());
                        tagMeta3.setDisplayName(Utils.format(displayname));
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt3.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        if (!SupremeTags.getInstance().getConfig().getBoolean("settings.locked-view")) {
                            lore3 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        } else {
                            lore3 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-permission");
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                            lore3.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        }
                        tagMeta3.setLore(Utils.color(lore3));
                        nbt3.getItem().setItemMeta(tagMeta3);
                        nbt3.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt3.getItem()});
                    } else if (material.contains("basehead-")) {
                        String id = material.replaceAll("basehead-", "");
                        tagItem = Utils.createSkull(id);
                        tagMeta2 = tagItem.getItemMeta();
                        assert (tagMeta2 != null);
                        nbt2 = new NBTItem(tagItem);
                        nbt2.setString("identifier", t2.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt2.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta2.setDisplayName(Utils.format(displayname));
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        if (!SupremeTags.getInstance().getConfig().getBoolean("settings.locked-view")) {
                            lore2 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        } else {
                            lore2 = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-permission");
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                            lore2.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        }
                        tagMeta2.setLore(Utils.color(lore2));
                        nbt2.getItem().setItemMeta(tagMeta2);
                        nbt2.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt2.getItem()});
                    } else {
                        ItemStack tagItem5 = new ItemStack(Material.valueOf((String)material.toUpperCase()), 1);
                        tagMeta = tagItem5.getItemMeta();
                        assert (tagMeta != null);
                        nbt = new NBTItem(tagItem5);
                        nbt.setString("identifier", t2.getIdentifier());
                        if (UserData.getActive(this.menuUtil.getOwner().getUniqueId()).equalsIgnoreCase(t2.getIdentifier()) && SupremeTags.getInstance().getConfig().getBoolean("settings.active-tag-glow")) {
                            nbt.getItem().addUnsafeEnchantment(Enchantment.KNOCKBACK, 1);
                        }
                        tagMeta.setDisplayName(Utils.format(displayname));
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                        tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        if (!SupremeTags.getInstance().getConfig().getBoolean("settings.locked-view")) {
                            lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-lore");
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        } else {
                            lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-menu-none-categories.tag-item.locked-permission");
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t2.getIdentifier() + ".description")))));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t2.getIdentifier()));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t2.getTag()));
                            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%cost%", String.valueOf(t2.getCost())));
                        }
                        tagMeta.setLore(Utils.color(lore));
                        nbt.getItem().setItemMeta(tagMeta);
                        nbt.setString("identifier", t2.getIdentifier());
                        this.inventory.addItem(new ItemStack[]{nbt.getItem()});
                    }
                }
                ++this.currentItemsOnPage;
            }
        }
    }

    public void getTagItemsEditor() {
        Map<String, Tag> tags = SupremeTags.getInstance().getTagManager().getTags();
        ArrayList<Tag> tag = new ArrayList<Tag>(tags.values());
        if (!tag.isEmpty()) {
            int maxItemsPerPage = 36;
            int startIndex = this.page * maxItemsPerPage;
            int endIndex = Math.min(startIndex + maxItemsPerPage, tag.size());
            tag.sort((tag1, tag2) -> {
                boolean hasPermission1 = this.menuUtil.getOwner().hasPermission(tag1.getPermission());
                boolean hasPermission2 = this.menuUtil.getOwner().hasPermission(tag2.getPermission());
                if (hasPermission1 && !hasPermission2) {
                    return -1;
                }
                if (!hasPermission1 && hasPermission2) {
                    return 1;
                }
                return tag1.getIdentifier().compareTo(tag2.getIdentifier());
            });
            this.currentItemsOnPage = 0;
            for (int i = startIndex; i < endIndex; ++i) {
                Tag t = tag.get(i);
                if (t == null) continue;
                String permission = SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".permission");
                String displayname = SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".displayname") != null ? Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".displayname")).replace("%tag%", t.getTag()) : Utils.format("&7Tag: " + t.getTag());
                if (SupremeTags.getInstance().isPlaceholderAPI()) {
                    displayname = Utils.replacePlaceholders(this.menuUtil.getOwner(), displayname);
                }
                String material = SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".display-item") != null ? SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".display-item") : "NAME_TAG";
                assert (permission != null);
                if (material.contains("hdb-")) {
                    HeadDatabaseAPI api = new HeadDatabaseAPI();
                    int id = Integer.parseInt(material.replaceAll("hdb-", ""));
                    ItemStack tagItem = api.getItemHead(String.valueOf(id));
                    ItemMeta tagMeta = tagItem.getItemMeta();
                    assert (tagMeta != null);
                    NBTItem nbt = new NBTItem(tagItem);
                    nbt.setString("identifier", t.getIdentifier());
                    tagMeta.setDisplayName(Utils.format(displayname));
                    tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                    tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                    tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                    tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                    ArrayList lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-editor-menu.tag-item.lore");
                    lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                    lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                    lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                    tagMeta.setLore(Utils.color(lore));
                    nbt.getItem().setItemMeta(tagMeta);
                    nbt.setString("identifier", t.getIdentifier());
                    this.inventory.addItem(new ItemStack[]{nbt.getItem()});
                } else if (material.contains("basehead-")) {
                    String id = material.replaceAll("basehead-", "");
                    ItemStack tagItem = Utils.createSkull(id);
                    ItemMeta tagMeta = tagItem.getItemMeta();
                    assert (tagMeta != null);
                    NBTItem nbt = new NBTItem(tagItem);
                    nbt.setString("identifier", t.getIdentifier());
                    tagMeta.setDisplayName(Utils.format(displayname));
                    tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                    tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                    tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                    tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                    ArrayList lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-editor-menu.tag-item.lore");
                    lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                    lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                    lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                    tagMeta.setLore(Utils.color(lore));
                    nbt.getItem().setItemMeta(tagMeta);
                    nbt.setString("identifier", t.getIdentifier());
                    this.inventory.addItem(new ItemStack[]{nbt.getItem()});
                } else {
                    ItemStack tagItem = new ItemStack(Material.valueOf((String)material.toUpperCase()), 1);
                    ItemMeta tagMeta = tagItem.getItemMeta();
                    assert (tagMeta != null);
                    NBTItem nbt = new NBTItem(tagItem);
                    nbt.setString("identifier", t.getIdentifier());
                    tagMeta.setDisplayName(Utils.format(displayname));
                    tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                    tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                    tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                    tagMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                    ArrayList lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("gui.tag-editor-menu.tag-item.lore");
                    lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%description%", Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".description")))));
                    lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%identifier%", t.getIdentifier()));
                    lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tag%", t.getTag()));
                    tagMeta.setLore(Utils.color(lore));
                    nbt.getItem().setItemMeta(tagMeta);
                    nbt.setString("identifier", t.getIdentifier());
                    this.inventory.addItem(new ItemStack[]{nbt.getItem()});
                }
                ++this.currentItemsOnPage;
            }
        }
    }

    public int getCurrentItemsOnPage() {
        return this.currentItemsOnPage;
    }
}

