/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.handlers.menu;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.noscape.project.supremetags.SupremeTags;
import net.noscape.project.supremetags.handlers.menu.MenuUtil;
import net.noscape.project.supremetags.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class Menu
implements InventoryHolder {
    protected Inventory inventory;
    protected MenuUtil menuUtil;
    protected ItemStack GLASS = this.makeItem(Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.glass-material")).toUpperCase()), " ", new String[0]);

    public Menu(MenuUtil menuUtil) {
        this.menuUtil = menuUtil;
    }

    public abstract String getMenuName();

    public abstract int getSlots();

    public abstract void handleMenu(InventoryClickEvent var1);

    public abstract void setMenuItems();

    public void open() {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.getSlots(), (String)this.getMenuName());
        this.setMenuItems();
        this.menuUtil.getOwner().openInventory(this.inventory);
    }

    public void refresh() {
        this.menuUtil.getOwner().updateInventory();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public ItemStack makeItem(Material material, String displayName, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta itemMeta = item.getItemMeta();
        assert (itemMeta != null);
        itemMeta.setDisplayName(Utils.format(displayName));
        itemMeta.setLore(Arrays.asList(lore));
        item.setItemMeta(itemMeta);
        return item;
    }

    public ItemStack makeItem(Material material, String displayName, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta itemMeta = item.getItemMeta();
        assert (itemMeta != null);
        itemMeta.setDisplayName(Utils.format(displayName));
        itemMeta.setLore(Utils.color(lore));
        item.setItemMeta(itemMeta);
        return item;
    }

    public void fillEmpty() {
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            if (this.inventory.getItem(i) != null) continue;
            this.inventory.setItem(i, this.GLASS);
        }
    }
}

