/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.guis.tageditor;

import de.tr7zw.nbtapi.NBTItem;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import net.noscape.project.supremetags.SupremeTags;
import net.noscape.project.supremetags.guis.tageditor.SpecificTagMenu;
import net.noscape.project.supremetags.handlers.Tag;
import net.noscape.project.supremetags.handlers.menu.MenuUtil;
import net.noscape.project.supremetags.handlers.menu.Paged;
import net.noscape.project.supremetags.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class TagEditorMenu
extends Paged {
    private final Map<String, Tag> tags = SupremeTags.getInstance().getTagManager().getTags();

    public TagEditorMenu(MenuUtil menuUtil) {
        super(menuUtil);
    }

    @Override
    public String getMenuName() {
        return Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.tag-editor-menu.title")).replaceAll("%page%", String.valueOf(this.getPage())));
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player player = (Player)e.getWhoClicked();
        ArrayList<String> tag = new ArrayList<String>(this.tags.keySet());
        String back = SupremeTags.getInstance().getConfig().getString("gui.strings.back-item");
        String close = SupremeTags.getInstance().getConfig().getString("gui.strings.close-item");
        String next = SupremeTags.getInstance().getConfig().getString("gui.strings.next-item");
        String refresh = SupremeTags.getInstance().getConfig().getString("gui.strings.refresh-item");
        String reset = SupremeTags.getInstance().getConfig().getString("gui.strings.reset-item");
        String active = SupremeTags.getInstance().getConfig().getString("gui.strings.active-item");
        if (!(ChatColor.stripColor((String)Objects.requireNonNull(e.getCurrentItem().getItemMeta()).getDisplayName()).startsWith("Active") || ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName()).equalsIgnoreCase("Next") || ChatColor.stripColor((String)Objects.requireNonNull(e.getCurrentItem().getItemMeta()).getDisplayName()).equalsIgnoreCase("Personal Tags") || ChatColor.stripColor((String)Objects.requireNonNull(e.getCurrentItem().getItemMeta()).getDisplayName()).equalsIgnoreCase("Back") || ChatColor.stripColor((String)Objects.requireNonNull(e.getCurrentItem().getItemMeta()).getDisplayName()).equalsIgnoreCase("Refresh"))) {
            NBTItem nbt = new NBTItem(e.getCurrentItem());
            String identifier = nbt.getString("identifier");
            this.menuUtil.setIdentifier(identifier);
            new SpecificTagMenu(SupremeTags.getMenuUtilIdentifier(player, identifier)).open();
        }
        if (e.getCurrentItem().getType().equals((Object)Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.close-menu-material")).toUpperCase()))) {
            player.closeInventory();
        }
        if (e.getCurrentItem().getType().equals((Object)Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.back-next-material")).toUpperCase()))) {
            if (e.getCurrentItem().getItemMeta().getDisplayName().equalsIgnoreCase(Utils.format(back))) {
                if (this.page != 0) {
                    --this.page;
                    super.open();
                }
            } else if (e.getCurrentItem().getItemMeta().getDisplayName().equalsIgnoreCase(Utils.format(next)) && this.index + 1 < tag.size() && this.getCurrentItemsOnPage() == 36) {
                ++this.page;
                super.open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.getTagItemsEditor();
        this.applyEditorLayout();
    }
}

