/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.guis.tageditor;

import java.util.ArrayList;
import java.util.Objects;
import net.noscape.project.supremetags.SupremeTags;
import net.noscape.project.supremetags.enums.EditingType;
import net.noscape.project.supremetags.handlers.Editor;
import net.noscape.project.supremetags.handlers.Tag;
import net.noscape.project.supremetags.handlers.menu.Menu;
import net.noscape.project.supremetags.handlers.menu.MenuUtil;
import net.noscape.project.supremetags.utils.Utils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class SpecificTagMenu
extends Menu {
    public SpecificTagMenu(MenuUtil menuUtil) {
        super(menuUtil);
    }

    @Override
    public String getMenuName() {
        return "Tag \u279f [" + this.menuUtil.getIdentifier() + "]";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player player = (Player)e.getWhoClicked();
        ItemStack i = e.getCurrentItem();
        if (i == null) {
            return;
        }
        if (i.getItemMeta() == null) {
            return;
        }
        if (SupremeTags.getInstance().getEditorList().containsKey(player)) {
            return;
        }
        String displayname = Utils.deformat(i.getItemMeta().getDisplayName());
        if (displayname.equalsIgnoreCase("Change Tag")) {
            Editor editor = new Editor(this.menuUtil.getIdentifier(), EditingType.CHANGING_TAG);
            SupremeTags.getInstance().getEditorList().put(player, editor);
            player.closeInventory();
            Utils.msgPlayer(player, "&8[&6&lTags&8] &7You are setting a new tag. &6Type it in chat.");
        } else if (displayname.equalsIgnoreCase("Change Description")) {
            Editor editor = new Editor(this.menuUtil.getIdentifier(), EditingType.CHANGING_DESCRIPTION);
            SupremeTags.getInstance().getEditorList().put(player, editor);
            player.closeInventory();
            Utils.msgPlayer(player, "&8[&6&lTags&8] &7You are setting a new description. &6Type it in chat.");
        } else if (displayname.equalsIgnoreCase("Change Category")) {
            Editor editor = new Editor(this.menuUtil.getIdentifier(), EditingType.CHANGING_CATEGORY);
            SupremeTags.getInstance().getEditorList().put(player, editor);
            player.closeInventory();
            Utils.msgPlayer(player, "&8[&6&lTags&8] &7You are setting a new category. &6Type it in chat.");
        } else if (displayname.equalsIgnoreCase("Change Permission")) {
            Editor editor = new Editor(this.menuUtil.getIdentifier(), EditingType.CHANGING_PERMISSION);
            SupremeTags.getInstance().getEditorList().put(player, editor);
            player.closeInventory();
            Utils.msgPlayer(player, "&8[&6&lTags&8] &7You are setting a new permission. &6Type it in chat.");
        } else if (displayname.equalsIgnoreCase("Delete Tag")) {
            SupremeTags.getInstance().getTagManager().deleteTag(player, this.menuUtil.getIdentifier());
            player.closeInventory();
            Utils.msgPlayer(player, "&8[&6&lTags&8] &7Tag deleted!");
        } else {
            e.setCancelled(true);
        }
    }

    @Override
    public void setMenuItems() {
        if (this.menuUtil.getIdentifier() != null && SupremeTags.getInstance().getTagManager().getTag(this.menuUtil.getIdentifier()) != null) {
            Tag t = SupremeTags.getInstance().getTagManager().getTag(this.menuUtil.getIdentifier());
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("&7Identifier: &6" + t.getIdentifier());
            lore.add("&7Tag: " + t.getTag());
            lore.add("&7Permission: &6" + t.getPermission());
            lore.add("&7Category: &6" + t.getCategory());
            lore.add("&7Cost: &6" + t.getCost());
            lore.add("&7Description:");
            lore.add("&6" + t.getDescription());
            String displayname = SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".displayname") != null ? Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + t.getIdentifier() + ".displayname")).replace("%tag%", t.getTag()) : Utils.format("&7Tag: " + t.getTag());
            this.getInventory().setItem(4, this.makeItem(Material.BOOK, Utils.format(displayname), lore));
            ArrayList<String> c_tag = new ArrayList<String>();
            c_tag.add("&7Current: &6" + t.getTag());
            this.getInventory().setItem(20, this.makeItem(Material.NAME_TAG, Utils.format("&e&lChange Tag"), c_tag));
            ArrayList<String> c_desc = new ArrayList<String>();
            c_desc.add("&7Current: &6" + t.getDescription());
            this.getInventory().setItem(29, this.makeItem(Material.OAK_SIGN, Utils.format("&e&lChange Description"), c_desc));
            ArrayList<String> c_cat = new ArrayList<String>();
            c_cat.add("&7Current: &6" + t.getCategory());
            this.getInventory().setItem(22, this.makeItem(Material.BOOK, Utils.format("&e&lChange Category"), c_cat));
            ArrayList<String> c_perm = new ArrayList<String>();
            c_perm.add("&7Current: &6" + t.getPermission());
            this.getInventory().setItem(31, this.makeItem(Material.REDSTONE_TORCH, Utils.format("&e&lChange Permission"), c_perm));
            this.getInventory().setItem(24, this.makeItem(Material.BARRIER, Utils.format("&c&lComing Soon!"), new String[0]));
            this.getInventory().setItem(33, this.makeItem(Material.BARRIER, Utils.format("&c&lComing Soon!"), new String[0]));
            ArrayList<String> c_delete = new ArrayList<String>();
            c_delete.add("&7This cannot be undone!");
            this.getInventory().setItem(49, this.makeItem(Material.RED_WOOL, Utils.format("&c&lDelete Tag"), c_delete));
        }
        this.fillEmpty();
    }
}

