/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.guis;

import de.tr7zw.nbtapi.NBTItem;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import net.noscape.project.supremetags.SupremeTags;
import net.noscape.project.supremetags.api.events.TagAssignEvent;
import net.noscape.project.supremetags.api.events.TagBuyEvent;
import net.noscape.project.supremetags.api.events.TagResetEvent;
import net.noscape.project.supremetags.guis.MainMenu;
import net.noscape.project.supremetags.handlers.Tag;
import net.noscape.project.supremetags.handlers.menu.MenuUtil;
import net.noscape.project.supremetags.handlers.menu.Paged;
import net.noscape.project.supremetags.storage.UserData;
import net.noscape.project.supremetags.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;

public class CategoryMenu
extends Paged {
    private final Map<String, Tag> tags = SupremeTags.getInstance().getTagManager().getTags();
    private final Map<Integer, String> dataItem = SupremeTags.getInstance().getTagManager().getDataItem();

    public CategoryMenu(MenuUtil menuUtil) {
        super(menuUtil);
    }

    @Override
    public String getMenuName() {
        return Utils.format(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("categories." + this.menuUtil.getCategory() + ".title")).replaceAll("%page%", String.valueOf(this.getPage())));
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player player = (Player)e.getWhoClicked();
        String back = SupremeTags.getInstance().getConfig().getString("gui.strings.back-item");
        String close = SupremeTags.getInstance().getConfig().getString("gui.strings.close-item");
        String next = SupremeTags.getInstance().getConfig().getString("gui.strings.next-item");
        String refresh = SupremeTags.getInstance().getConfig().getString("gui.strings.refresh-item");
        String reset = SupremeTags.getInstance().getConfig().getString("gui.strings.reset-item");
        String active = SupremeTags.getInstance().getConfig().getString("gui.strings.active-item");
        String insufficient = SupremeTags.getInstance().getConfig().getString("messages.insufficient-funds");
        String unlocked = SupremeTags.getInstance().getConfig().getString("messages.tag-unlocked");
        if (e.getCurrentItem().getType().equals((Object)Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.glass-material")).toUpperCase()))) {
            e.setCancelled(true);
        }
        ArrayList<String> tag = new ArrayList<String>(this.tags.keySet());
        NBTItem nbt = new NBTItem(e.getCurrentItem());
        if (nbt.hasTag("identifier")) {
            String identifier = nbt.getString("identifier");
            Tag t = SupremeTags.getInstance().getTagManager().getTag(identifier);
            if (!SupremeTags.getInstance().getTagManager().isCost()) {
                if (!UserData.getActive(player.getUniqueId()).equalsIgnoreCase(identifier) && identifier != null) {
                    if (player.hasPermission(t.getPermission())) {
                        TagAssignEvent tagevent = new TagAssignEvent(player, identifier, false);
                        Bukkit.getPluginManager().callEvent((Event)tagevent);
                        if (tagevent.isCancelled()) {
                            return;
                        }
                        UserData.setActive((OfflinePlayer)player, tagevent.getTag());
                        super.open();
                        this.menuUtil.setIdentifier(tagevent.getTag());
                        if (SupremeTags.getInstance().getConfig().getBoolean("settings.gui-messages")) {
                            Utils.msgPlayer(player, SupremeTags.getInstance().getConfig().getString("messages.tag-select-message").replace("%identifier%", identifier));
                        }
                    } else {
                        Utils.msgPlayer(player, SupremeTags.getInstance().getConfig().getString("messages.locked-tag"));
                    }
                }
            } else if (player.hasPermission(t.getPermission())) {
                if (!UserData.getActive(player.getUniqueId()).equalsIgnoreCase(identifier) && identifier != null) {
                    TagAssignEvent tagevent = new TagAssignEvent(player, identifier, false);
                    Bukkit.getPluginManager().callEvent((Event)tagevent);
                    if (tagevent.isCancelled()) {
                        return;
                    }
                    UserData.setActive((OfflinePlayer)player, tagevent.getTag());
                    super.open();
                    this.menuUtil.setIdentifier(tagevent.getTag());
                    if (SupremeTags.getInstance().getConfig().getBoolean("settings.gui-messages")) {
                        Utils.msgPlayer(player, SupremeTags.getInstance().getConfig().getString("messages.tag-select-message").replace("%identifier%", identifier));
                    }
                }
            } else {
                double cost = t.getCost();
                if (Utils.hasAmount(player, cost)) {
                    TagBuyEvent tagevent = new TagBuyEvent(player, identifier, cost, false);
                    Bukkit.getPluginManager().callEvent((Event)tagevent);
                    if (tagevent.isCancelled()) {
                        return;
                    }
                    Utils.take(player, cost);
                    Utils.addPerm(player, t.getPermission());
                    Utils.msgPlayer(player, unlocked.replaceAll("%identifier%", t.getIdentifier()));
                    super.open();
                } else {
                    Utils.msgPlayer(player, insufficient.replaceAll("%cost%", String.valueOf(t.getCost())));
                }
            }
        }
        if (e.getCurrentItem().getItemMeta().getDisplayName().equalsIgnoreCase(Utils.format(close))) {
            player.closeInventory();
        }
        if (e.getCurrentItem().getItemMeta().getDisplayName().equalsIgnoreCase(Utils.format(reset))) {
            TagResetEvent tagEvent;
            if (!SupremeTags.getInstance().getConfig().getBoolean("settings.forced-tag")) {
                tagEvent = new TagResetEvent(player, false);
                Bukkit.getPluginManager().callEvent((Event)tagEvent);
                if (tagEvent.isCancelled()) {
                    return;
                }
                UserData.setActive((OfflinePlayer)player, "None");
                super.open();
                this.menuUtil.setIdentifier("None");
                if (SupremeTags.getInstance().getConfig().getBoolean("settings.gui-messages")) {
                    Utils.msgPlayer(player, SupremeTags.getInstance().getConfig().getString("messages.reset-message"));
                }
            } else {
                tagEvent = new TagResetEvent(player, false);
                Bukkit.getPluginManager().callEvent((Event)tagEvent);
                if (tagEvent.isCancelled()) {
                    return;
                }
                String defaultTag = SupremeTags.getInstance().getConfig().getString("settings.default-tag");
                UserData.setActive((OfflinePlayer)player, defaultTag);
                super.open();
                this.menuUtil.setIdentifier(defaultTag);
                if (SupremeTags.getInstance().getConfig().getBoolean("settings.gui-messages")) {
                    Utils.msgPlayer(player, SupremeTags.getInstance().getConfig().getString("messages.reset-message"));
                }
            }
        }
        if (e.getCurrentItem().getType().equals((Object)Material.valueOf((String)Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("gui.layout.back-next-material")).toUpperCase()))) {
            if (e.getCurrentItem().getItemMeta().getDisplayName().equalsIgnoreCase(Utils.format(back))) {
                if (this.page != 0) {
                    --this.page;
                    super.open();
                } else {
                    new MainMenu(SupremeTags.getMenuUtil(player)).open();
                }
            } else if (e.getCurrentItem().getItemMeta().getDisplayName().equalsIgnoreCase(Utils.format(next)) && this.index + 1 < tag.size()) {
                ++this.page;
                super.open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.applyLayout();
        if (SupremeTags.getInstance().getTagManager().isCost()) {
            this.getTagItemsCostCategory();
        } else {
            this.getTagItemsCategory();
        }
    }
}

