/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.commands;

import java.util.Iterator;
import net.noscape.project.supremetags.SupremeTags;
import net.noscape.project.supremetags.guis.MainMenu;
import net.noscape.project.supremetags.guis.TagMenu;
import net.noscape.project.supremetags.guis.tageditor.TagEditorMenu;
import net.noscape.project.supremetags.handlers.Tag;
import net.noscape.project.supremetags.storage.UserData;
import net.noscape.project.supremetags.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Tags
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        String reload = SupremeTags.getInstance().getConfig().getString("messages.reload");
        String noperm = SupremeTags.getInstance().getConfig().getString("messages.no-permission");
        String notags = SupremeTags.getInstance().getConfig().getString("messages.no-tags");
        String commanddisabled = SupremeTags.getInstance().getConfig().getString("messages.tag-command-disabled");
        String invalidtag = SupremeTags.getInstance().getConfig().getString("messages.invalid-tag");
        if (!(sender instanceof Player)) {
            if (cmd.getName().equalsIgnoreCase("tags")) {
                if (args.length == 0) {
                    this.sendHelp(sender);
                } else if (args.length == 3) {
                    if (args[0].equalsIgnoreCase("create")) {
                        String name = args[1];
                        String tag = args[2];
                        SupremeTags.getInstance().getTagManager().createTag(sender, name, tag, "&7My tag is " + name, "supremetags.tag." + name, 0.0);
                    } else if (args[0].equalsIgnoreCase("settag")) {
                        String name = args[1];
                        String tag = args[2];
                        SupremeTags.getInstance().getTagManager().setTag(sender, name, tag);
                    } else if (args[0].equalsIgnoreCase("set")) {
                        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
                        String identifier = args[2];
                        if (SupremeTags.getInstance().getTagManager().getTags().containsKey(identifier)) {
                            UserData.setActive(target, identifier);
                            Utils.msgPlayer(sender, "&8[&6&lTag&8] &7Set &b" + target.getName() + "'s &7tag to &b" + identifier);
                        } else {
                            Utils.msgPlayer(sender, invalidtag);
                        }
                    }
                } else if (args.length == 1) {
                    if (args[0].equalsIgnoreCase("reload")) {
                        SupremeTags.getInstance().reloadConfig();
                        SupremeTags.getInstance().getTagManager().unloadTags();
                        SupremeTags.getInstance().getTagManager().loadTags();
                        SupremeTags.getInstance().getTagManager().getDataItem().clear();
                        SupremeTags.getInstance().getTagManager().setCost(SupremeTags.getInstance().getConfig().getBoolean("settings.cost-system"));
                        SupremeTags.getInstance().getCategoryManager().loadCategories();
                        SupremeTags.getInstance().getCategoryManager().loadCategoriesTags();
                        Utils.msgPlayer(sender, reload);
                    } else if (args[0].equalsIgnoreCase("help")) {
                        this.sendHelp(sender);
                    }
                } else if (args.length == 2) {
                    if (args[0].equalsIgnoreCase("delete")) {
                        String name = args[1];
                        SupremeTags.getInstance().getTagManager().deleteTag(sender, name);
                    } else if (args[0].equalsIgnoreCase("reset")) {
                        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
                        if (SupremeTags.getInstance().getConfig().isBoolean("settings.forced-tag")) {
                            String defaultTag = SupremeTags.getInstance().getConfig().getString("settings.default-tag");
                            UserData.setActive(target, defaultTag);
                            Utils.msgPlayer(sender, "&8[&6&lTag&8] &7Reset &b" + target.getName() + "'s &7tag back to " + defaultTag);
                        } else {
                            UserData.setActive(target, "None");
                            Utils.msgPlayer(sender, "&8[&6&lTag&8] &7Reset &b" + target.getName() + "'s &7tag back to None.");
                        }
                    } else {
                        this.sendHelp(sender);
                    }
                }
            }
            return true;
        }
        Player player = (Player)sender;
        if (cmd.getName().equalsIgnoreCase("tags")) {
            if (args.length == 0) {
                if (player.hasPermission("supremetags.menu")) {
                    if (!SupremeTags.getInstance().isDisabledWorldsTag()) {
                        boolean lockedView = SupremeTags.getInstance().getConfig().getBoolean("settings.locked-view");
                        boolean costSystem = SupremeTags.getInstance().getConfig().getBoolean("settings.cost-system");
                        boolean useCategories = SupremeTags.getInstance().getConfig().getBoolean("settings.categories");
                        if (!lockedView && !costSystem || lockedView && !costSystem) {
                            if (this.hasTags(player)) {
                                if (useCategories) {
                                    new MainMenu(SupremeTags.getMenuUtil(player)).open();
                                } else {
                                    new TagMenu(SupremeTags.getMenuUtil(player)).open();
                                }
                            } else {
                                Utils.msgPlayer(player, notags);
                            }
                        } else if (!lockedView && !costSystem) {
                            if (!this.hasTags(player)) {
                                Utils.msgPlayer(player, notags);
                            } else if (useCategories) {
                                new MainMenu(SupremeTags.getMenuUtil(player)).open();
                            } else {
                                new TagMenu(SupremeTags.getMenuUtil(player)).open();
                            }
                        } else if (useCategories) {
                            new MainMenu(SupremeTags.getMenuUtil(player)).open();
                        } else {
                            new TagMenu(SupremeTags.getMenuUtil(player)).open();
                        }
                    } else {
                        Iterator lockedView = SupremeTags.getInstance().getConfig().getStringList("settings.disabled-worlds").iterator();
                        if (lockedView.hasNext()) {
                            String world = (String)lockedView.next();
                            if (player.getWorld().getName().equalsIgnoreCase(world)) {
                                Utils.msgPlayer(player, commanddisabled);
                            } else {
                                boolean lockedView2 = SupremeTags.getInstance().getConfig().getBoolean("settings.locked-view");
                                boolean costSystem = SupremeTags.getInstance().getConfig().getBoolean("settings.cost-system");
                                boolean useCategories = SupremeTags.getInstance().getConfig().getBoolean("settings.categories");
                                if (!lockedView2 && !costSystem || lockedView2 && !costSystem) {
                                    if (this.hasTags(player)) {
                                        if (useCategories) {
                                            new MainMenu(SupremeTags.getMenuUtil(player)).open();
                                        } else {
                                            new TagMenu(SupremeTags.getMenuUtil(player)).open();
                                        }
                                    } else {
                                        Utils.msgPlayer(player, notags);
                                    }
                                } else if (useCategories) {
                                    new MainMenu(SupremeTags.getMenuUtil(player)).open();
                                } else {
                                    new TagMenu(SupremeTags.getMenuUtil(player)).open();
                                }
                            }
                        }
                    }
                } else {
                    Utils.msgPlayer(player, noperm);
                }
            } else if (args.length == 3) {
                if (args[0].equalsIgnoreCase("create")) {
                    if (player.hasPermission("supremetags.admin")) {
                        String name = args[1];
                        String tag = args[2];
                        SupremeTags.getInstance().getTagManager().createTag(player, name, tag, "&7My tag is " + name, "supremetags.tag." + name, 0.0);
                    } else {
                        Utils.msgPlayer(player, noperm);
                    }
                } else if (args[0].equalsIgnoreCase("settag")) {
                    if (player.hasPermission("supremetags.admin")) {
                        String name = args[1];
                        String tag = args[2];
                        SupremeTags.getInstance().getTagManager().setTag(player, name, tag);
                    } else {
                        Utils.msgPlayer(player, noperm);
                    }
                } else if (args[0].equalsIgnoreCase("setcategory")) {
                    if (player.hasPermission("supremetags.admin")) {
                        String name = args[1];
                        String category = args[2];
                        SupremeTags.getInstance().getTagManager().setCategory(player, name, category);
                    } else {
                        Utils.msgPlayer(player, noperm);
                    }
                } else if (args[0].equalsIgnoreCase("set")) {
                    if (player.hasPermission("supremetags.admin")) {
                        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
                        String identifier = args[2];
                        if (SupremeTags.getInstance().getTagManager().getTags().containsKey(identifier)) {
                            UserData.setActive(target, identifier);
                            Utils.msgPlayer(player, "&8[&6&lTag&8] &7Set &b" + target.getName() + "'s &7tag to &b" + identifier);
                        } else {
                            Utils.msgPlayer(player, invalidtag);
                        }
                    } else {
                        Utils.msgPlayer(player, noperm);
                    }
                } else {
                    this.sendHelp(sender);
                }
            } else if (args.length == 1) {
                if (args[0].equalsIgnoreCase("reload")) {
                    if (player.hasPermission("supremetags.admin")) {
                        SupremeTags.getInstance().reloadConfig();
                        SupremeTags.getInstance().getTagManager().unloadTags();
                        SupremeTags.getInstance().getTagManager().loadTags();
                        SupremeTags.getInstance().getTagManager().getDataItem().clear();
                        SupremeTags.getInstance().getTagManager().setCost(SupremeTags.getInstance().getConfig().getBoolean("settings.cost-system"));
                        SupremeTags.getInstance().getCategoryManager().loadCategories();
                        SupremeTags.getInstance().getCategoryManager().loadCategoriesTags();
                        Utils.msgPlayer(player, reload);
                    } else {
                        Utils.msgPlayer(player, noperm);
                    }
                } else if (args[0].equalsIgnoreCase("help")) {
                    if (player.hasPermission("supremetags.admin")) {
                        this.sendHelp(player);
                    } else {
                        Utils.msgPlayer(player, noperm);
                    }
                } else if (args[0].equalsIgnoreCase("editor")) {
                    if (player.hasPermission("supremetags.admin")) {
                        new TagEditorMenu(SupremeTags.getMenuUtil(player)).open();
                    } else {
                        Utils.msgPlayer(player, noperm);
                    }
                } else if (args[0].equalsIgnoreCase("merge")) {
                    if (player.hasPermission("supremetags.admin")) {
                        SupremeTags.getInstance().getMergeManager().merge(player);
                    } else {
                        Utils.msgPlayer(player, noperm);
                    }
                }
            } else if (args.length == 2) {
                if (args[0].equalsIgnoreCase("delete")) {
                    if (player.hasPermission("supremetags.admin")) {
                        String name = args[1];
                        SupremeTags.getInstance().getTagManager().deleteTag(player, name);
                    } else {
                        Utils.msgPlayer(player, noperm);
                    }
                } else if (args[0].equalsIgnoreCase("reset")) {
                    if (player.hasPermission("supremetags.admin")) {
                        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
                        if (SupremeTags.getInstance().getConfig().isBoolean("settings.forced-tag")) {
                            String defaultTag = SupremeTags.getInstance().getConfig().getString("settings.default-tag");
                            UserData.setActive(target, defaultTag);
                            Utils.msgPlayer(player, "&8[&6&lTag&8] &7Reset &b" + target.getName() + "'s &7tag back to " + defaultTag);
                        } else {
                            UserData.setActive(target, "None");
                            Utils.msgPlayer(player, "&8[&6&lTag&8] &7Reset &b" + target.getName() + "'s &7tag back to None.");
                        }
                    } else {
                        Utils.msgPlayer(player, noperm);
                    }
                } else {
                    this.sendHelp(player);
                }
            } else {
                this.sendHelp(sender);
            }
        }
        return false;
    }

    public boolean hasTags(Player player) {
        for (Tag tag : SupremeTags.getInstance().getTagManager().getTags().values()) {
            if (!player.hasPermission(tag.getPermission())) continue;
            return true;
        }
        return false;
    }

    public void sendHelp(Player player) {
        Utils.msgPlayer(player, "", "&6&lSupremeTags Help:", "", "&e/tags &7- will open the tag menu.", "&e/tags create <identifier> <tag> &7- creates a new tag.", "&e/tags delete <identifier> &7- creates a new tag.", "&e/tags settag <identifier> <tag> &7- sets tag style for the existing tag.", "&e/tags set <player> <identifier> &7- sets a new tag for that player.", "&e/tags reset <player> &7- resets the players tag to None.", "&e/tags merge &7- merges deluxetags into supremetags.", "&e/tags reload &7- reloads the config.yml & unloads/loads tags.", "&e/tags help &7- displays this help message.", "");
    }

    public void sendHelp(CommandSender player) {
        Utils.msgPlayer(player, "", "&6&lSupremeTags Help:", "", "&e/tags &7- will open the tag menu.", "&e/tags create <identifier> <tag> &7- creates a new tag.", "&e/tags delete <identifier> &7- creates a new tag.", "&e/tags settag <identifier> <tag> &7- sets tag style for the existing tag.", "&e/tags set <player> <identifier> &7- sets a new tag for that player.", "&e/tags reset <player> &7- resets the players tag to None.", "&e/tags merge &7- merges deluxetags into supremetags.", "&e/tags reload &7- reloads the config.yml & unloads/loads tags.", "&e/tags help &7- displays this help message.", "");
    }
}

