/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.checkers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.noscape.project.supremetags.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class UpdateChecker
implements Listener {
    private final int RESOURCE_ID = 103140;
    private final Plugin plugin;
    private String spigotVersion;
    private final String pluginVersion;
    private boolean updateAvailable;

    public UpdateChecker(Plugin instance) {
        this.plugin = instance;
        this.pluginVersion = instance.getDescription().getVersion();
    }

    public boolean hasUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getSpigotVersion() {
        return this.spigotVersion;
    }

    public void fetch() {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            try {
                HttpsURLConnection con = (HttpsURLConnection)new URL("https://api.spigotmc.org/legacy/update.php?resource=103140").openConnection();
                con.setRequestMethod("GET");
                this.spigotVersion = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            }
            catch (Exception ex) {
                this.plugin.getLogger().info("Failed to check for updates on spigot.");
                return;
            }
            if (this.spigotVersion == null || this.spigotVersion.isEmpty()) {
                return;
            }
            this.updateAvailable = this.spigotIsNewer();
            if (!this.updateAvailable) {
                return;
            }
        });
    }

    private boolean spigotIsNewer() {
        String spV;
        if (this.spigotVersion == null || this.spigotVersion.isEmpty()) {
            return false;
        }
        String plV = this.toReadable(this.pluginVersion);
        return plV.compareTo(spV = this.toReadable(this.spigotVersion)) < 0;
    }

    private String toReadable(String version) {
        if (version.contains("-DEV-")) {
            version = version.split("-DEV-")[0];
        }
        return version.replaceAll("\\.", "");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onJoin(PlayerJoinEvent e) {
        if (e.getPlayer().hasPermission("supremetags.updates") && this.hasUpdateAvailable()) {
            TextComponent message = new TextComponent(TextComponent.fromLegacyText((String)Utils.format("&7Click &a[HERE] &7download it!")));
            this.setClickBroadcastEvent(message, "/");
            e.getPlayer().spigot().sendMessage((BaseComponent)message);
            Utils.msgPlayer(e.getPlayer(), "&8[&aSupremeTags&8] &7Update found for &a&lST &8(&f&nSupremeTags-" + this.getSpigotVersion() + "&r&8)");
        }
    }

    public void setClickBroadcastEvent(TextComponent component, String click) {
        if (click == null || click.length() == 0) {
            return;
        }
        switch (click.charAt(0)) {
            case '/': {
                component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, click));
                return;
            }
            case '*': {
                component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, click.substring(1)));
                return;
            }
        }
        component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, click));
    }
}

