/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import net.noscape.project.supremetags.api.SupremeTagsAPI;
import net.noscape.project.supremetags.checkers.Metrics;
import net.noscape.project.supremetags.checkers.UpdateChecker;
import net.noscape.project.supremetags.commands.Tags;
import net.noscape.project.supremetags.guis.tageditor.EditorListener;
import net.noscape.project.supremetags.handlers.Editor;
import net.noscape.project.supremetags.handlers.SetupTag;
import net.noscape.project.supremetags.handlers.hooks.PAPI;
import net.noscape.project.supremetags.handlers.menu.MenuListener;
import net.noscape.project.supremetags.handlers.menu.MenuUtil;
import net.noscape.project.supremetags.listeners.PlayerEvents;
import net.noscape.project.supremetags.listeners.SetupListener;
import net.noscape.project.supremetags.managers.CategoryManager;
import net.noscape.project.supremetags.managers.MergeManager;
import net.noscape.project.supremetags.managers.PlayerManager;
import net.noscape.project.supremetags.managers.TagManager;
import net.noscape.project.supremetags.storage.H2Database;
import net.noscape.project.supremetags.storage.H2UserData;
import net.noscape.project.supremetags.storage.MySQL;
import net.noscape.project.supremetags.storage.MySQLUserData;
import net.noscape.project.supremetags.storage.PlayerConfig;
import net.noscape.project.supremetags.storage.UserData;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class SupremeTags
extends JavaPlugin {
    private static SupremeTags instance;
    private TagManager tagManager;
    private CategoryManager categoryManager;
    private MergeManager mergeManager;
    private static SupremeTagsAPI api;
    private static Economy econ;
    private static Permission perms;
    private static MySQL mysql;
    private static H2Database h2;
    private final H2UserData h2user = new H2UserData();
    private static String connectionURL;
    private final MySQLUserData user = new MySQLUserData();
    private static final HashMap<Player, MenuUtil> menuUtilMap;
    private final HashMap<Player, Editor> editorList = new HashMap();
    private final HashMap<Player, SetupTag> setupList = new HashMap();
    private boolean legacy_format;
    private boolean cmi_hex;
    private boolean disabledWorldsTag;
    private PlayerManager playerManager;
    private PlayerConfig playerConfig;
    public static File latestConfigFile;
    public static FileConfiguration latestConfigConfig;
    private final String host = this.getConfig().getString("data.address");
    private final int port = this.getConfig().getInt("data.port");
    private final String database = this.getConfig().getString("data.database");
    private final String username = this.getConfig().getString("data.username");
    private final String password = this.getConfig().getString("data.password");
    private final String options = this.getConfig().getString("data.options");

    public void onEnable() {
        this.init();
    }

    public void onDisable() {
        this.tagManager.unloadTags();
        this.editorList.clear();
        if (this.isMySQL().booleanValue()) {
            mysql.disconnected();
        }
    }

    private void init() {
        instance = this;
        Logger logger = Bukkit.getLogger();
        this.saveDefaultConfig();
        this.callMetrics();
        this.sendConsoleLog();
        if (this.isH2().booleanValue()) {
            connectionURL = "jdbc:h2:" + this.getDataFolder().getAbsolutePath() + "/database";
            h2 = new H2Database(connectionURL);
        }
        if (this.isMySQL().booleanValue()) {
            mysql = new MySQL(this.host, this.port, this.database, this.username, this.password, this.options);
        }
        this.tagManager = new TagManager(this.getConfig().getBoolean("settings.cost-system"));
        this.categoryManager = new CategoryManager();
        this.playerManager = new PlayerManager();
        this.mergeManager = new MergeManager();
        Objects.requireNonNull(this.getCommand("tags")).setExecutor((CommandExecutor)new Tags());
        this.getServer().getPluginManager().registerEvents((Listener)new MenuListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEvents(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EditorListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new UpdateChecker((Plugin)this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SetupListener(), (Plugin)this);
        this.legacy_format = this.getConfig().getBoolean("settings.legacy-hex-format");
        this.cmi_hex = this.getConfig().getBoolean("settings.cmi-color-support");
        this.disabledWorldsTag = this.getConfig().getBoolean("settings.tag-command-in-disabled-worlds");
        this.merge(logger);
        if (this.isPlaceholderAPI()) {
            logger.info(ChatColor.YELLOW + "> PlaceholderAPI: Found");
            new PAPI(this).register();
        } else {
            logger.info(ChatColor.RED + "> PlaceholderAPI: Not Found!");
        }
        this.tagManager.loadTags();
        this.categoryManager.loadCategories();
        this.categoryManager.loadCategoriesTags();
        this.tagManager.getDataItem().clear();
        this.deleteCurrentLatestConfig();
        latestConfigFile = new File(this.getDataFolder(), "DEFAULT-CONFIG-LATEST.yml");
        if (!latestConfigFile.exists()) {
            this.saveResource("DEFAULT-CONFIG-LATEST.yml", true);
        }
        latestConfigConfig = new YamlConfiguration();
        try {
            latestConfigConfig.load(latestConfigFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        api = new SupremeTagsAPI();
        if (this.tagManager.getTags().size() == 0) {
            this.tagManager.loadTags();
        }
    }

    public static SupremeTags getInstance() {
        return instance;
    }

    public TagManager getTagManager() {
        return this.tagManager;
    }

    public CategoryManager getCategoryManager() {
        return this.categoryManager;
    }

    public static MenuUtil getMenuUtil(Player player) {
        if (menuUtilMap.containsKey(player)) {
            return menuUtilMap.get(player);
        }
        MenuUtil menuUtil = new MenuUtil(player, UserData.getActive(player.getUniqueId()));
        menuUtilMap.put(player, menuUtil);
        return menuUtil;
    }

    public static MenuUtil getMenuUtilIdentifier(Player player, String identifier) {
        if (menuUtilMap.containsKey(player)) {
            return menuUtilMap.get(player);
        }
        MenuUtil menuUtil = new MenuUtil(player, identifier);
        menuUtilMap.put(player, menuUtil);
        return menuUtil;
    }

    public static MenuUtil getMenuUtil(Player player, String category) {
        if (menuUtilMap.containsKey(player)) {
            return menuUtilMap.get(player);
        }
        MenuUtil menuUtil = new MenuUtil(player, UserData.getActive(player.getUniqueId()), category);
        menuUtilMap.put(player, menuUtil);
        return menuUtil;
    }

    public HashMap<Player, MenuUtil> getMenuUtil() {
        return menuUtilMap;
    }

    public static String getConnectionURL() {
        return connectionURL;
    }

    public H2UserData getUserData() {
        return this.h2user;
    }

    public static H2Database getDatabase() {
        return h2;
    }

    public MySQLUserData getUser() {
        return SupremeTags.instance.user;
    }

    public static MySQL getMysql() {
        return mysql;
    }

    public void reloadConfig() {
        super.reloadConfig();
        this.legacy_format = this.getConfig().getBoolean("settings.legacy-hex-format");
        this.cmi_hex = this.getConfig().getBoolean("settings.cmi-color-support");
        this.disabledWorldsTag = this.getConfig().getBoolean("settings.tag-command-in-disabled-worlds");
    }

    public boolean isLegacyFormat() {
        return this.legacy_format;
    }

    public void merge(Logger log) {
        this.mergeManager.merge(log);
    }

    private void sendConsoleLog() {
        Logger logger = Bukkit.getLogger();
        logger.info("");
        logger.info(ChatColor.GREEN + "  ____  _   _ ____  ____  _____ __  __ _____ _____  _    ____ ____  ");
        logger.info(ChatColor.GREEN + " / ___|| | | |  _ \\|  _ \\| ____|  \\/  | ____|_   _|/ \\  / ___/ ___| ");
        logger.info(ChatColor.GREEN + " \\___ \\| | | | |_) | |_) |  _| | |\\/| |  _|   | | / _ \\| |  _\\___ \\ ");
        logger.info(ChatColor.GREEN + "  ___) | |_| |  __/|  _ <| |___| |  | | |___  | |/ ___ \\ |_| |___) |");
        logger.info(ChatColor.GREEN + " |____/ \\___/|_|   |_| \\_\\_____|_|  |_|_____| |_/_/   \\_\\____|____/ ");
        logger.info(ChatColor.GRAY + " Allow players to show off their supreme tags!");
        logger.info("");
        logger.info(ChatColor.YELLOW + "> Version: " + this.getDescription().getVersion());
        logger.info(ChatColor.YELLOW + "> Author: DevScape");
        if (this.getServer().getPluginManager().getPlugin("NBTAPI") == null) {
            logger.warning(ChatColor.RED + "> NBTAPI: Supremetags requires NBTAPI to run, disabling plugin....");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        } else {
            logger.info(ChatColor.YELLOW + "> NBTAPI: Found!");
        }
        if (this.getServer().getPluginManager().getPlugin("Vault") != null) {
            this.setupEconomy();
            this.setupPermissions();
            logger.info(ChatColor.YELLOW + "> Vault: Found!");
        } else {
            logger.info(ChatColor.RED + "> Vault: Not Found!");
        }
        if (this.isH2().booleanValue()) {
            logger.info(ChatColor.YELLOW + "> Database: H2!");
        } else if (this.isMySQL().booleanValue()) {
            logger.info(ChatColor.YELLOW + "> Database: MySQL!");
        }
        if (this.getConfig().getBoolean("settings.update-check")) {
            UpdateChecker updater = new UpdateChecker((Plugin)this);
            updater.fetch();
            if (updater.hasUpdateAvailable()) {
                logger.info(ChatColor.AQUA + "> An update is available! " + updater.getSpigotVersion());
                logger.info(ChatColor.AQUA + "Download at https://www.spigotmc.org/resources/%E2%9C%85-supremetags-%E2%9C%85-1-8-1-19-placeholderapi-support-unlimited-tags-%E2%9C%85.103140/");
            } else {
                logger.info(ChatColor.YELLOW + "> Plugin up to date!");
            }
        }
    }

    public Boolean isH2() {
        return Objects.requireNonNull(this.getConfig().getString("data.type")).equalsIgnoreCase("H2");
    }

    public Boolean isMySQL() {
        return Objects.requireNonNull(this.getConfig().getString("data.type")).equalsIgnoreCase("MYSQL");
    }

    private void callMetrics() {
        int pluginId = 18038;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("used_language", () -> this.getConfig().getString("language", "en")));
        metrics.addCustomChart(new Metrics.DrilldownPie("java_version", () -> {
            HashMap map = new HashMap();
            String javaVersion = System.getProperty("java.version");
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(javaVersion, 1);
            if (javaVersion.startsWith("1.7")) {
                map.put("Java 1.7", entry);
            } else if (javaVersion.startsWith("1.8")) {
                map.put("Java 1.8", entry);
            } else if (javaVersion.startsWith("1.9")) {
                map.put("Java 1.9", entry);
            } else {
                map.put("Other", entry);
            }
            return map;
        }));
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        econ = (Economy)rsp.getProvider();
        return econ != null;
    }

    private boolean setupPermissions() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Permission.class);
        perms = (Permission)rsp.getProvider();
        return perms != null;
    }

    public static Economy getEconomy() {
        return econ;
    }

    public static Permission getPermissions() {
        return perms;
    }

    public static SupremeTagsAPI getTagAPI() {
        return api;
    }

    private void deleteCurrentLatestConfig() {
        latestConfigFile = new File(this.getDataFolder(), "DEFAULT-CONFIG-LATEST.yml");
        if (latestConfigFile.exists()) {
            latestConfigFile.delete();
        }
    }

    public HashMap<Player, Editor> getEditorList() {
        return this.editorList;
    }

    public boolean isCMIHex() {
        return this.cmi_hex;
    }

    public boolean isDisabledWorldsTag() {
        return this.disabledWorldsTag;
    }

    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public MergeManager getMergeManager() {
        return this.mergeManager;
    }

    public PlayerConfig getPlayerConfig() {
        return this.playerConfig;
    }

    public HashMap<Player, SetupTag> getSetupList() {
        return this.setupList;
    }

    public boolean isPlaceholderAPI() {
        return this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    static {
        econ = null;
        perms = null;
        menuUtilMap = new HashMap();
    }
}

