/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.utils;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.noscape.project.supremetags.SupremeTags;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Utils {
    public static String format(String message) {
        if (SupremeTags.getInstance().isLegacyFormat()) {
            message = message.replace(">>", "").replace("<<", "");
            Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]){6}");
            Matcher matcher = hexPattern.matcher(message);
            while (matcher.find()) {
                ChatColor hexColor = ChatColor.of((String)matcher.group().substring(1));
                String before = message.substring(0, matcher.start());
                String after = message.substring(matcher.end());
                message = before + hexColor + after;
                matcher = hexPattern.matcher(message);
            }
            return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        }
        message = message.replace(">>", "").replace("<<", "");
        Pattern hexPattern = Pattern.compile("#([A-Fa-f0-9]){6}");
        Matcher matcher = hexPattern.matcher(message);
        while (matcher.find()) {
            ChatColor hexColor = ChatColor.of((String)matcher.group().substring(1));
            String before = message.substring(0, matcher.start());
            String after = message.substring(matcher.end());
            message = before + hexColor + after;
            matcher = hexPattern.matcher(message);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static String deformat(String str) {
        return ChatColor.stripColor((String)Utils.format(str));
    }

    public static void msgPlayer(Player player, String ... str) {
        for (String msg : str) {
            player.sendMessage(Utils.format(msg));
        }
    }

    public static void msgPlayer(CommandSender player, String ... str) {
        for (String msg : str) {
            player.sendMessage(Utils.format(msg));
        }
    }

    public static void titlePlayer(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        player.sendTitle(Utils.format(title), Utils.format(subtitle), fadeIn, stay, fadeOut);
    }

    public static void soundPlayer(Player player, Sound sound, float volume, float pitch) {
        player.playSound(player.getLocation(), sound, volume, pitch);
    }

    public static List<String> color(List<String> lore) {
        return lore.stream().map(Utils::format).collect(Collectors.toList());
    }
}

