/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.storage;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import org.bukkit.Bukkit;

public class MySQL {
    private final String host;
    private final int port;
    private final String database;
    private final String username;
    private final String password;
    private final String options;
    public Connection connection;
    private boolean isconnected = false;

    public MySQL(String host, int port, String database, String username, String password, String options) {
        this.host = host;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
        this.options = options;
        this.connect(host, port, database, username, password, true);
    }

    public void openConnection() throws SQLException {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            this.connection = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?" + this.options, this.username, this.password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String host, int port, String database, String user, String pass, boolean ssl) {
        try {
            MySQL mySQL = this;
            synchronized (mySQL) {
                if (this.connection != null && !this.connection.isClosed()) {
                    Logger.getLogger("Error: connection to sql was not successful.");
                    return;
                }
                Class.forName("com.mysql.cj.jdbc.Driver");
                this.connection = DriverManager.getConnection("jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=" + ssl + "&autoReconnect=true", user, pass);
                this.isconnected = true;
                this.createTable();
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
            Bukkit.getConsoleSender().sendMessage("MYSQL: Something wrong with connecting to mysql database type, check mysql data details before contacting the developer if you see this.");
        }
    }

    public void createTable() throws SQLException {
        String userTable = "CREATE TABLE IF NOT EXISTS `users` (`Name` VARCHAR(100), `UUID` VARCHAR(100) primary key, `Active` VARCHAR(100))";
        Statement stmt = this.connection.createStatement();
        stmt.execute(userTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateQuery(String query) {
        Connection con = this.connection;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = con.prepareStatement(query);
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.closeResources(null, preparedStatement);
        }
    }

    public void disconnected() {
        try {
            if (this.isConnected()) {
                this.connection.close();
                this.isconnected = false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public ResultSet executeQuery(String query) {
        if (this.isConnected()) {
            return null;
        }
        try {
            this.connection.createStatement().executeQuery(query);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void closeResources(ResultSet rs, PreparedStatement st) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isConnected() {
        return !this.isconnected;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

