/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.storage;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.noscape.project.supremetags.SupremeTags;

public class H2Database {
    private final String ConnectionURL;

    public H2Database(String connectionURL) {
        this.ConnectionURL = connectionURL;
        this.initialiseDatabase();
    }

    public Connection getConnection() {
        Connection connection = null;
        try {
            Class.forName("org.h2.Driver");
            connection = DriverManager.getConnection(SupremeTags.getConnectionURL());
        }
        catch (ClassNotFoundException | SQLException throwables) {
            throwables.printStackTrace();
            SupremeTags.getInstance().getLogger().info("------------------------------");
            SupremeTags.getInstance().getLogger().info("H2: Something wrong with connecting to h2-sql for SupremeTags, contact the developer if you see this.");
            SupremeTags.getInstance().getLogger().info("------------------------------");
        }
        return connection;
    }

    public void initialiseDatabase() {
        String userTable = "CREATE TABLE IF NOT EXISTS `users` (`Name` VARCHAR(100), `UUID` VARCHAR(100) primary key, `Active` VARCHAR(100))";
        try {
            PreparedStatement preparedStatement = this.getConnection().prepareStatement(userTable);
            preparedStatement.executeUpdate();
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }

    public String getConnectionURL() {
        return this.ConnectionURL;
    }
}

