/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import net.noscape.project.supremetags.SupremeTags;
import net.noscape.project.supremetags.handlers.Tag;
import net.noscape.project.supremetags.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TagManager {
    private final Map<String, Tag> tags = new HashMap<String, Tag>();
    private final Map<Integer, String> dataItem = new HashMap<Integer, String>();

    public TagManager() {
        this.sort();
    }

    public void createTag(Player player, String identifier, String tag_string, String description, String permission) {
        if (!this.tags.containsKey(identifier)) {
            String default_category = SupremeTags.getInstance().getConfig().getString("settings.default-category");
            Tag tag = new Tag(identifier, tag_string, default_category, permission);
            this.tags.put(identifier, tag);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".tag", (Object)tag_string);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".permission", (Object)permission);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".description", (Object)description);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".category", (Object)default_category);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".display-item", (Object)"NAME_TAG");
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".displayname", (Object)"&7Tag: %tag%");
            SupremeTags.getInstance().saveConfig();
            SupremeTags.getInstance().reloadConfig();
            Utils.msgPlayer(player, "&6[TAG] &7New tag created &6" + identifier + " &f- " + tag_string);
        } else {
            Utils.msgPlayer(player, "&c[&l!&c] &7This tag already exists.");
        }
    }

    public void createTag(CommandSender player, String identifier, String tag_string, String description, String permission) {
        if (!this.tags.containsKey(identifier)) {
            String default_category = SupremeTags.getInstance().getConfig().getString("settings.default-category");
            Tag tag = new Tag(identifier, tag_string, default_category, permission);
            this.tags.put(identifier, tag);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".tag", (Object)tag_string);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".permission", (Object)permission);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".description", (Object)description);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".category", (Object)default_category);
            SupremeTags.getInstance().saveConfig();
            SupremeTags.getInstance().reloadConfig();
            Utils.msgPlayer(player, "&6[TAG] &7New tag created &6" + identifier + " &f- " + tag_string);
        } else {
            Utils.msgPlayer(player, "&c[&l!&c] &7This tag already exists.");
        }
    }

    public void createTag(String identifier, String tag_string, String description, String permission) {
        if (!this.tags.containsKey(identifier)) {
            String default_category = SupremeTags.getInstance().getConfig().getString("settings.default-category");
            Tag tag = new Tag(identifier, tag_string, default_category, permission);
            this.tags.put(identifier, tag);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".tag", (Object)tag_string);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".permission", (Object)permission);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".description", (Object)description);
            SupremeTags.getInstance().getConfig().set("tags." + identifier + ".category", (Object)default_category);
            SupremeTags.getInstance().saveConfig();
            SupremeTags.getInstance().reloadConfig();
        }
    }

    public void deleteTag(CommandSender player, String identifier) {
        if (this.tags.containsKey(identifier)) {
            this.tags.remove(identifier);
            try {
                SupremeTags.getInstance().getConfig().set("tags." + identifier, null);
                SupremeTags.getInstance().saveConfig();
                SupremeTags.getInstance().reloadConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Utils.msgPlayer(player, "&6[TAG] &7Tag &6" + identifier + " &7is now deleted!");
        } else {
            Utils.msgPlayer(player, "&c[&l!&c] &7This tag doesn't exist!");
        }
    }

    public void deleteTag(Player player, String identifier) {
        if (this.tags.containsKey(identifier)) {
            this.tags.remove(identifier);
            try {
                SupremeTags.getInstance().getConfig().set("tags." + identifier, null);
                SupremeTags.getInstance().saveConfig();
                SupremeTags.getInstance().reloadConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Utils.msgPlayer(player, "&6[TAG] &7Tag &6" + identifier + " &7is now deleted!");
        } else {
            Utils.msgPlayer(player, "&c[&l!&c] &7This tag doesn't exist!");
        }
    }

    public void loadTags() {
        int count = 0;
        for (String identifier : Objects.requireNonNull(SupremeTags.getInstance().getConfig().getConfigurationSection("tags")).getKeys(false)) {
            String tag = SupremeTags.getInstance().getConfig().getString("tags." + identifier + ".tag");
            String category = SupremeTags.getInstance().getConfig().getString("tags." + identifier + ".category");
            String permission = SupremeTags.getInstance().getConfig().getString("tags." + identifier + ".permission");
            Tag t = new Tag(identifier, tag, category, permission);
            this.tags.put(identifier, t);
            ++count;
        }
        Bukkit.getConsoleSender().sendMessage("[TAGS] loaded " + count + " tag(s) successfully.");
    }

    public void unloadTags() {
        if (!this.tags.isEmpty()) {
            this.tags.clear();
        }
    }

    public Map<String, Tag> getTags() {
        return this.tags;
    }

    public Map<Integer, String> getDataItem() {
        return this.dataItem;
    }

    public void setTag(Player player, String identifier, String tag) {
        if (this.tags.containsKey(identifier)) {
            Tag t = this.tags.get(identifier);
            t.setTag(tag);
            try {
                SupremeTags.getInstance().getConfig().set("tags." + identifier + ".tag", (Object)t.getTag());
                SupremeTags.getInstance().saveConfig();
                SupremeTags.getInstance().reloadConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Utils.msgPlayer(player, "&6[TAG] &6" + t.getIdentifier() + "'s tag &7changed to " + t.getTag());
        } else {
            Utils.msgPlayer(player, "&6[TAG] &7This tag doesn't exist!");
        }
    }

    public void setCategory(Player player, String identifier, String category) {
        if (this.tags.containsKey(identifier)) {
            Tag t = this.tags.get(identifier);
            t.setCategory(category);
            try {
                SupremeTags.getInstance().getConfig().set("tags." + identifier + ".category", (Object)t.getCategory());
                SupremeTags.getInstance().saveConfig();
                SupremeTags.getInstance().reloadConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Utils.msgPlayer(player, "&6[TAG] &6" + t.getIdentifier() + "'s category &7changed to " + t.getCategory());
        } else {
            Utils.msgPlayer(player, "&6[TAG] &7This category doesn't exist!");
        }
    }

    public void setTag(CommandSender player, String identifier, String tag) {
        if (this.tags.containsKey(identifier)) {
            Tag t = this.tags.get(identifier);
            t.setTag(tag);
            try {
                SupremeTags.getInstance().getConfig().set("tags." + identifier + ".tag", (Object)t.getTag());
                SupremeTags.getInstance().saveConfig();
                SupremeTags.getInstance().reloadConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Utils.msgPlayer(player, "&6[TAG] &6" + t.getIdentifier() + "'s tag &7changed to " + t.getTag());
        } else {
            Utils.msgPlayer(player, "&6[TAG] &7This tag doesn't exist!");
        }
    }

    public void sort() {
        TreeSet<Map.Entry<String, Tag>> sortedSet = new TreeSet<Map.Entry<String, Tag>>((o1, o2) -> {
            int result = ((Tag)o1.getValue()).getIdentifier().compareTo(((Tag)o2.getValue()).getIdentifier());
            if ((result *= -1) == 0) {
                result = ((String)o1.getKey()).compareTo((String)o2.getKey());
            }
            return result;
        });
        sortedSet.addAll(this.tags.entrySet());
        for (Map.Entry entry : sortedSet) {
            System.out.println((String)entry.getKey() + "=" + entry.getValue());
        }
    }
}

