/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.guis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.noscape.project.supremetags.SupremeTags;
import net.noscape.project.supremetags.guis.CategoryMenu;
import net.noscape.project.supremetags.handlers.menu.Menu;
import net.noscape.project.supremetags.handlers.menu.MenuUtil;
import net.noscape.project.supremetags.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MainMenu
extends Menu {
    private final List<String> catorgies;
    private final Map<Integer, String> dataItem = new HashMap<Integer, String>();
    private final Map<String, Integer> categoriesTags;

    public MainMenu(MenuUtil menuUtil) {
        super(menuUtil);
        this.catorgies = SupremeTags.getInstance().getCategoryManager().getCatorgies();
        this.categoriesTags = SupremeTags.getInstance().getCategoryManager().getCatorgiesTags();
    }

    @Override
    public String getMenuName() {
        return Utils.format(SupremeTags.getInstance().getConfig().getString("gui.main-menu.title"));
    }

    @Override
    public int getSlots() {
        return SupremeTags.getInstance().getConfig().getInt("gui.main-menu.size");
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player player = (Player)e.getWhoClicked();
        String category = this.dataItem.get(e.getSlot());
        String material = SupremeTags.getInstance().getConfig().getString("categories." + category + ".material");
        String permission = SupremeTags.getInstance().getConfig().getString("categories." + category + ".permission");
        if (category != null && material != null && Objects.requireNonNull(e.getCurrentItem()).getType().equals((Object)Material.valueOf((String)material.toUpperCase()))) {
            if (permission != null && player.hasPermission(permission)) {
                this.menuUtil.setCategory(category);
                new CategoryMenu(SupremeTags.getMenuUtil(player, category)).open();
                this.menuUtil.getOwner().updateInventory();
            } else {
                Utils.msgPlayer(player, "&cYou don't have permission to access these tags.");
            }
        }
    }

    @Override
    public void setMenuItems() {
        for (String cats : this.getCatorgies()) {
            ArrayList lore;
            ItemMeta cat_itemMeta;
            ItemStack cat_item;
            if (cats == null) continue;
            boolean canSee = SupremeTags.getInstance().getConfig().getBoolean("categories." + cats + ".permission-see-category");
            String permission = SupremeTags.getInstance().getConfig().getString("categories." + cats + ".permission");
            String material = SupremeTags.getInstance().getConfig().getString("categories." + cats + ".material");
            int slot = SupremeTags.getInstance().getConfig().getInt("categories." + cats + ".slot");
            String displayname = SupremeTags.getInstance().getConfig().getString("categories." + cats + ".id_display");
            if (permission != null && this.menuUtil.getOwner().hasPermission(permission) && canSee) {
                assert (material != null);
                cat_item = new ItemStack(Material.valueOf((String)material.toUpperCase()), 1);
                cat_itemMeta = cat_item.getItemMeta();
                assert (cat_itemMeta != null);
                cat_itemMeta.setDisplayName(Utils.format(displayname));
                cat_itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                cat_itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                cat_itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("categories." + cats + ".lore");
                if (this.categoriesTags.get(cats) != null) {
                    lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tags_amount%", String.valueOf(this.categoriesTags.get(cats))));
                } else {
                    lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tags_amount%", String.valueOf(0)));
                }
                cat_itemMeta.setLore(Utils.color(lore));
                cat_item.setItemMeta(cat_itemMeta);
                this.dataItem.put(slot, cats);
                this.inventory.setItem(slot, cat_item);
                continue;
            }
            if (permission != null && !this.menuUtil.getOwner().hasPermission(permission) && !canSee) {
                assert (material != null);
                cat_item = new ItemStack(Material.valueOf((String)material.toUpperCase()), 1);
                cat_itemMeta = cat_item.getItemMeta();
                assert (cat_itemMeta != null);
                cat_itemMeta.setDisplayName(Utils.format(displayname));
                cat_itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                cat_itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                cat_itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("categories." + cats + ".lore");
                if (this.categoriesTags.get(cats) != null) {
                    lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tags_amount%", String.valueOf(this.categoriesTags.get(cats))));
                } else {
                    lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tags_amount%", String.valueOf(0)));
                }
                cat_itemMeta.setLore(Utils.color(lore));
                cat_item.setItemMeta(cat_itemMeta);
                this.dataItem.put(slot, cats);
                this.inventory.setItem(slot, cat_item);
                continue;
            }
            if (permission == null || !this.menuUtil.getOwner().hasPermission(permission) || canSee) continue;
            assert (material != null);
            cat_item = new ItemStack(Material.valueOf((String)material.toUpperCase()), 1);
            cat_itemMeta = cat_item.getItemMeta();
            assert (cat_itemMeta != null);
            cat_itemMeta.setDisplayName(Utils.format(displayname));
            cat_itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            cat_itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
            cat_itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
            lore = (ArrayList)SupremeTags.getInstance().getConfig().getStringList("categories." + cats + ".lore");
            lore.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("%tags_amount%", String.valueOf(this.categoriesTags.get(cats))));
            cat_itemMeta.setLore(Utils.color(lore));
            cat_item.setItemMeta(cat_itemMeta);
            this.dataItem.put(slot, cats);
            this.inventory.setItem(slot, cat_item);
        }
    }

    public List<String> getCatorgies() {
        return this.catorgies;
    }

    public Map<Integer, String> getDataItem() {
        return this.dataItem;
    }
}

