/*
 * Decompiled with CFR 0.152.
 */
package net.noscape.project.supremetags.commands;

import java.io.File;
import java.util.Objects;
import net.noscape.project.supremetags.SupremeTags;
import net.noscape.project.supremetags.guis.MainMenu;
import net.noscape.project.supremetags.guis.TagMenu;
import net.noscape.project.supremetags.storage.H2UserData;
import net.noscape.project.supremetags.storage.UserData;
import net.noscape.project.supremetags.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Tags
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            if (cmd.getName().equalsIgnoreCase("tags") && args.length != 0) {
                if (args.length == 3) {
                    if (args[0].equalsIgnoreCase("create")) {
                        String name = args[1];
                        String tag = args[2];
                        SupremeTags.getInstance().getTagManager().createTag(sender, name, tag, "&7My tag is " + name, "supremetags.tag." + name);
                    } else if (args[0].equalsIgnoreCase("settag")) {
                        String name = args[1];
                        String tag = args[2];
                        SupremeTags.getInstance().getTagManager().setTag(sender, name, tag);
                    } else if (args[0].equalsIgnoreCase("set")) {
                        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
                        String identifier = args[2];
                        if (SupremeTags.getInstance().getTagManager().getTags().containsKey(identifier)) {
                            UserData.setActive(target, identifier);
                            Utils.msgPlayer(sender, "&8[&b&lTag&8] &7Set &b" + target.getName() + "'s &7tag to &b" + identifier);
                        } else {
                            Utils.msgPlayer(sender, "&cThis tag does not exist.");
                        }
                    }
                } else if (args.length == 1) {
                    if (args[0].equalsIgnoreCase("reload")) {
                        SupremeTags.getInstance().reloadConfig();
                        SupremeTags.getInstance().getTagManager().unloadTags();
                        SupremeTags.getInstance().getTagManager().loadTags();
                        SupremeTags.getInstance().getTagManager().getDataItem().clear();
                        if (Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("settings.layout")).equalsIgnoreCase("layout1")) {
                            SupremeTags.setLayout("layout1");
                        } else if (Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("settings.layout")).equalsIgnoreCase("layout2")) {
                            SupremeTags.setLayout("layout2");
                        }
                        SupremeTags.getInstance().getCategoryManager().loadCategories();
                        SupremeTags.getInstance().getCategoryManager().loadCategoriesTags();
                        Utils.msgPlayer(sender, "&6[TAG] &7Reloaded plugin.");
                    } else if (args[0].equalsIgnoreCase("help")) {
                        Utils.msgPlayer(sender, "", "&eSupremeTags Admin Help:", "", "&6/tags &7- will open the tag menu.", "&6/tags create <identifier> <tag> &7- creates a new tag.", "&6/tags delete <identifier> &7- creates a new tag.", "&6/tags settag <identifier> <tag> &7- sets tag style for the existing tag.", "&6/tags set <player> <identifier> &7- sets a new tag for that player.", "&6/tags reset <player> &7- resets the players tag to None.", "&6/tags merge &7- merges deluxetags into supremetags.", "&6/tags reload &7- reloads the config.yml & unloads/loads tags.", "&6/tags help &7- displays this help message.", "");
                    }
                } else if (args.length == 2) {
                    if (args[0].equalsIgnoreCase("delete")) {
                        String name = args[1];
                        SupremeTags.getInstance().getTagManager().deleteTag(sender, name);
                    } else if (args[0].equalsIgnoreCase("reset")) {
                        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
                        H2UserData.setActive(target, "None");
                        Utils.msgPlayer(sender, "&8[&b&lTag&8] &7Reset &b" + target.getName() + "'s &7tag back to None.");
                    } else {
                        Utils.msgPlayer(sender, "", "&eSupremeTags Admin Help:", "", "&6/tags &7- will open the tag menu.", "&6/tags create <identifier> <tag> &7- creates a new tag.", "&6/tags delete <identifier> &7- creates a new tag.", "&6/tags settag <identifier> <tag> &7- sets tag style for the existing tag.", "&6/tags set <player> <identifier> &7- sets a new tag for that player.", "&6/tags reset <player> &7- resets the players tag to None.", "&6/tags merge &7- merges deluxetags into supremetags.", "&6/tags reload &7- reloads the config.yml & unloads/loads tags.", "&6/tags help &7- displays this help message.", "");
                    }
                }
            }
            return true;
        }
        Player player = (Player)sender;
        if (cmd.getName().equalsIgnoreCase("tags")) {
            if (args.length == 0) {
                if (player.hasPermission("supremetags.menu")) {
                    if (this.hasTags(player)) {
                        if (SupremeTags.getInstance().getConfig().getBoolean("settings.categories")) {
                            new MainMenu(SupremeTags.getMenuUtil(player)).open();
                        } else {
                            new TagMenu(SupremeTags.getMenuUtil(player)).open();
                        }
                    } else {
                        Utils.msgPlayer(player, "&cYou have no tags yet.");
                    }
                } else {
                    Utils.msgPlayer(player, "&cNo Permission, required permission: &7'supremetags.menu'");
                }
            } else if (args.length == 3) {
                if (args[0].equalsIgnoreCase("create")) {
                    if (player.hasPermission("supremetags.admin")) {
                        String name = args[1];
                        String tag = args[2];
                        SupremeTags.getInstance().getTagManager().createTag(player, name, tag, "&7My tag is " + name, "supremetags.tag." + name);
                    } else {
                        Utils.msgPlayer(player, "&cNo Permission.");
                    }
                } else if (args[0].equalsIgnoreCase("settag")) {
                    if (player.hasPermission("supremetags.admin")) {
                        String name = args[1];
                        String tag = args[2];
                        SupremeTags.getInstance().getTagManager().setTag(player, name, tag);
                    } else {
                        Utils.msgPlayer(player, "&cNo Permission.");
                    }
                } else if (args[0].equalsIgnoreCase("setcategory")) {
                    if (player.hasPermission("supremetags.admin")) {
                        String name = args[1];
                        String category = args[2];
                        SupremeTags.getInstance().getTagManager().setCategory(player, name, category);
                    } else {
                        Utils.msgPlayer(player, "&cNo Permission.");
                    }
                } else if (args[0].equalsIgnoreCase("set")) {
                    if (player.hasPermission("supremetags.admin")) {
                        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
                        String identifier = args[2];
                        if (SupremeTags.getInstance().getTagManager().getTags().containsKey(identifier)) {
                            UserData.setActive(target, identifier);
                            Utils.msgPlayer(player, "&8[&b&lTag&8] &7Set &b" + target.getName() + "'s &7tag to &b" + identifier);
                        } else {
                            Utils.msgPlayer(player, "&cThis tag does not exist.");
                        }
                    } else {
                        Utils.msgPlayer(player, "&cNo Permission.");
                    }
                }
            } else if (args.length == 1) {
                if (args[0].equalsIgnoreCase("reload")) {
                    if (player.hasPermission("supremetags.admin")) {
                        SupremeTags.getInstance().reloadConfig();
                        SupremeTags.getInstance().getTagManager().unloadTags();
                        SupremeTags.getInstance().getTagManager().loadTags();
                        SupremeTags.getInstance().getTagManager().getDataItem().clear();
                        if (Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("settings.layout")).equalsIgnoreCase("layout1")) {
                            SupremeTags.setLayout("layout1");
                        } else if (Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("settings.layout")).equalsIgnoreCase("layout2")) {
                            SupremeTags.setLayout("layout2");
                        }
                        SupremeTags.getInstance().getCategoryManager().loadCategories();
                        SupremeTags.getInstance().getCategoryManager().loadCategoriesTags();
                        Utils.msgPlayer(player, "&6[TAG] &7Reloaded plugin.");
                    } else {
                        Utils.msgPlayer(player, "&cNo Permission.");
                    }
                } else if (args[0].equalsIgnoreCase("help")) {
                    if (player.hasPermission("supremetags.admin")) {
                        Utils.msgPlayer(player, "", "&eSupremeTags Admin Help:", "", "&6/tags &7- will open the tag menu.", "&6/tags create <identifier> <tag> &7- creates a new tag.", "&6/tags delete <identifier> &7- creates a new tag.", "&6/tags settag <identifier> <tag> &7- sets tag style for the existing tag.", "&6/tags setcategory <identifier> <category> &7- sets the category of the tag.", "&6/tags set <player> <identifier> &7- sets a new tag for that player.", "&6/tags reset <player> &7- resets the players tag to None.", "&6/tags merge &7- merges deluxetags into supremetags.", "&6/tags reload &7- reloads the config.yml & unloads/loads tags.", "&6/tags help &7- displays this help message.", "");
                    } else {
                        Utils.msgPlayer(player, "&cNo Permission.");
                    }
                } else if (args[0].equalsIgnoreCase("merge")) {
                    if (player.hasPermission("supremetags.admin")) {
                        File configFile = new File(Bukkit.getServer().getWorldContainer().getAbsolutePath() + "/plugins/DeluxeTags/config.yml");
                        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                        if (configFile.exists()) {
                            if (config.getConfigurationSection("deluxetags") != null) {
                                for (String identifier : Objects.requireNonNull(config.getConfigurationSection("deluxetags")).getKeys(false)) {
                                    if (!SupremeTags.getInstance().getTagManager().getTags().containsKey(identifier)) {
                                        String tag = config.getString("deluxetags." + identifier + ".tag");
                                        String description = config.getString("deluxetags." + identifier + ".description");
                                        String permission = config.getString("deluxetags." + identifier + ".permission");
                                        SupremeTags.getInstance().getTagManager().createTag(player, identifier, tag, description, permission);
                                    }
                                    Utils.msgPlayer(player, "&6Merger: &7Added all new tags from &6DeluxeTags&7 were added, any existing tags with the same name won't be added.");
                                }
                            } else {
                                Utils.msgPlayer(player, "&6Error: &7DeluxeTags tag config area is empty.");
                            }
                        } else {
                            Utils.msgPlayer(player, "&6Error: &7DeluxeTags can not be found.");
                        }
                    } else {
                        Utils.msgPlayer(player, "&cNo Permission.");
                    }
                }
            } else if (args.length == 2) {
                if (args[0].equalsIgnoreCase("delete")) {
                    if (player.hasPermission("supremetags.admin")) {
                        String name = args[1];
                        SupremeTags.getInstance().getTagManager().deleteTag(player, name);
                    } else {
                        Utils.msgPlayer(player, "&cNo Permission.");
                    }
                } else if (args[0].equalsIgnoreCase("reset")) {
                    if (player.hasPermission("supremetags.admin")) {
                        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
                        H2UserData.setActive(target, "None");
                        Utils.msgPlayer(player, "&8[&b&lTag&8] &7Reset &b" + target.getName() + "'s &7tag back to None.");
                    } else {
                        Utils.msgPlayer(player, "&cNo Permission.");
                    }
                } else {
                    Utils.msgPlayer(player, "", "&eSupremeTags Admin Help:", "", "&6/tags &7- will open the tag menu.", "&6/tags create <identifier> <tag> &7- creates a new tag.", "&6/tags delete <identifier> &7- creates a new tag.", "&6/tags settag <identifier> <tag> &7- sets tag style for the existing tag.", "&6/tags set <player> <identifier> &7- sets a new tag for that player.", "&6/tags reset <player> &7- resets the players tag to None.", "&6/tags merge &7- merges deluxetags into supremetags.", "&6/tags reload &7- reloads the config.yml & unloads/loads tags.", "&6/tags help &7- displays this help message.", "");
                }
            }
        }
        return false;
    }

    public boolean hasTags(Player player) {
        for (String tag : SupremeTags.getInstance().getTagManager().getTags().keySet()) {
            if (!player.hasPermission(Objects.requireNonNull(SupremeTags.getInstance().getConfig().getString("tags." + tag + ".permission")))) continue;
            return true;
        }
        return false;
    }
}

